// Untriangulate.js
//

function Vec3D_normalize ( v1 ) {
  if (v1.norm() == 0) return Vec3D();
  return v1.multiply( 1 / v1.norm() );
}

function buildUI(tool) {
	tool.addParameterSeparator("Untriangulate");
	tool.addParameterFloat("tolerance angle", 0.0001, 0, 180, false, false);
	tool.addParameterBool("keep perpendicular", 1, 0, 1, false, false);
	tool.addParameterButton("untriangulate", "apply", "Untriangulate");
	
}

function polyAreNeighbor( core, p1, p2 ) {
  var i, j;
  var size1 = core.polygonSize( p1 );
  var size2 = core.polygonSize( p2 );
  
  for (i = 0;i < size1;i++) {
    var v1 = core.vertexIndex( p1, i );
    var v2 = core.vertexIndex( p1, (i == size1 - 1)? 0 : i+1 );
    
    for (j = 0;j < size2;j++) {
      var t1 = core.vertexIndex( p2, j );
      var t2 = core.vertexIndex( p2, (j == size2 - 1)? 0 : j+1 );
      
      
      //print (v1 + ', ' + v2 + ' / ' + t1 + ', ' + t2);
      if ((v1 == t1 && v2 == t2) || (v2 == t1 &&  v1 == t2)) {
        return true;
      }
    }
  }
  return false;
}

// helper function
function getVerticesOrder(core, normal, v_list) { // this function doesn't work correctly. :(
    var v_len = v_list.length;
    if( v_len < 1) return new Array;
    var centerVec = core.vertex(v_list[0]);
    var radian_p = 180/Math.PI;
    for (var i = 1;i < v_len;i++) {
        centerVec = centerVec.add(core.vertex(v_list[i]));
    }
    centerVec = centerVec.multiply(1/v_len); // calc center point
    
    // rotate matrix
    var theta = Math.acos(normal.y)*radian_p;
    var phi = Math.atan2(normal.x, normal.z)*radian_p;
    //print("theta:"+theta+", phi:"+phi);
    var rotMat_a = new Mat4D(ROTATE_HPB, -phi, 0, 0);
    var rotMat_b = new Mat4D(ROTATE_HPB, 0, -theta, 0);
    //
    comp_list = [ [], [] ];
    
    //print('v_list: '+v_list);
    //print('centerVec: '+centerVec.toString());
    //print('ss');
    for (var i = 0;i < v_len;i++) {
        var vec = core.vertex(v_list[i]);
        var comp_vec = rotMat_b.multiply(rotMat_a.multiply(vec.sub(centerVec)));
        
        var s = Math.atan2(comp_vec.z, comp_vec.x) *180/Math.PI;
        
        //print(v_list[i] + ', s: '+s.toFixed(3));
        if (s > 0) { // 0 - 180
            comp_list[0].push( [s, v_list[i]] );
        } else { // -180 - 0
            comp_list[1].push( [s, v_list[i]] );
        }
    }
    
    //comp_list[0] = comp_list[0].reverse();
    
    comp_list[0].sort( compareFunc );
    comp_list[1].sort( compareFunc );
    
    //print( '0:' + comp_list[0] );
    //print( '1:' + comp_list[1] );
    
    //print('comp_list: '+comp_list);
    var res_list = new Array;
    for (var i = 0;i < 2;i++) {
        var list = comp_list[i];
        var len = list.length;
        for (var j = 0;j < len;j++) {
            res_list.push(list[j][1]);
        }
    }
    return res_list;
    
}

function compareFunc( a, b ) {
  if (a[0] == b[0]) return 0;
  
  return (a[0] > b[0])? 1 : -1;
}

function Untriangulate(tool) {
	var obj = tool.document().selectedObject();
	var tol = tool.getParameter("tolerance angle");
	var keepPerp = tool.getParameter("keep perpendicular");
	
	if (! obj || obj.family() != NGONFAMILY) {
		return;
	}
	
	var c_tol = 1 - (tol*Math.PI/180);
	
	var core = obj.core();
	var polygonCount = core.polygonCount();
  
  var i, j, k;
  
  var loop = true;
  var counter = 0;
  
  obj.recordGeometryForUndo();
  
  print( '---- Untriangulate.js');
  
  var sel = 0;
  for (i = 0;i < polygonCount;i++) {
    if (core.polygonSelection(i)) {
      sel++;
    }
  }
  
  var creations = [];
  var checked_list = [];
  
  while( loop ) {
    polygonCount = core.polygonCount();
    var baseList = [];
    var detectionList = {};
    
    // store triagle polygon as base
    for (i = 0;i < polygonCount;i++) {
      if ((sel == 0 || core.polygonSelection(i)) && core.polygonSize(i) == 3 && checked_list.indexOf(i) === -1) {
        baseIndex = i;
        baseNormal = core.normal(i);
        
        baseList.push( [ i, baseNormal ] );
        break;
      }
    }
    
    // detection check
    if (baseList.length == 0) { // no triangles;
      loop = false;
    }
    
    for (i = 0;i < baseList.length;i++) {
      detectionList[baseList[i][0]] = [];
      // store base indices for dot calculation
      var baseIndices_master = [];
      var size = core.polygonSize( baseList[i][0] );
      for (k = 0;k < size;k++) {
        baseIndices_master.push( core.vertexIndex( baseList[i][0], k ) );
      }
      //print( 'baseIndices_master: ' + baseList[i][0] + ' - ' + baseIndices_master );
      
      for (j = 0;j < polygonCount;j++) {
        if (baseList[i][0] != j) {
          var tarNormal = core.normal(j);
          
          // sel check and normal match
          var baseDot = baseList[i][1].dot(tarNormal);
          baseDot = (baseDot.dot)? baseDot.x : baseDot;
          if ((sel == 0 || core.polygonSelection(j)) && baseDot > c_tol) {
            var baseIndices = baseIndices_master.concat();
            
            // creation check
            var create = true;
            var indices = [];
            size = core.polygonSize(j);
            for (k = 0;k < size;k++) {
              indices.push( core.vertexIndex( j, k ) );
              baseIndices.pushUnique( core.vertexIndex( j, k ) );
            }
            
            // perpendicular check if new polygon size is 4
            if (keepPerp && baseIndices.length == 4) {
              var baseIndices = getVerticesOrder( core, tarNormal, baseIndices );
              //print( 'baseIndices: ' + baseIndices );
              var v1 = core.vertex( baseIndices[0] );
              var v2 = core.vertex( baseIndices[1] );
              var v3 = core.vertex( baseIndices[2] );
              
              var va = Vec3D_normalize( v2.sub( v1 ) );
              var vb = Vec3D_normalize( v2.sub( v3 ) );
              
              var dotAB = va.dot(vb);
              dotAB = (dotAB.dot)? dotAB.x : dotAB;
              //print( 'dotAB: ' + dotAB.x.toFixed(3) );
              if (dotAB != 0) {
                create = false;
              }
            }
            //
            var creations_length = creations.length;
            for (k = 0;k < creations_length;k++) {
              var creation = creations[k];
              var create_match = 0;
              
              if (creation.length == indices.length) {
                for (var ii = 0;ii < creation.length;ii++) {
                  if (indices.indexOf( creation[ii] ) > -1) {
                    create_match++;
                  }
                }
                if (create_match == indices.length) {
                  create = false;
                  //print( 'match:' + j );
                  break;
                }
              }
            }
            if (create) detectionList[baseList[i][0]].push( j );
          }
        }
      }
    }
    
    var detected = false;
    var detectedPolys;
    
    for (i in detectionList) {
      //print( '- neighbor: ' + i );
      for(j = 0;j < detectionList[i].length;j++) {
        if (polyAreNeighbor(core, parseInt(i), detectionList[i][j])) {
          core.setPolygonSelection( parseInt(i), true );
          core.setPolygonSelection( detectionList[i][j], true);
          
          detected = true;
          detectedPolys = [ parseInt(i), detectionList[i][j] ];
          break;
        }
      }
      if (detected) break;
    }
    
    // detection check
    if (!detected) {
      if ( checked_list.pushUnique( parseInt(i) ) === -1 ) loop = false;
    }
    
    //print( 'checked_list: ' + checked_list );
    
    if (!loop) {
      print('-- finished: no more available triangle. / ' + counter);
    }
    
    // if detected, create polygon and delete
    if (detected) {
      var indices = [];
      var uvs = {};
      
      var size1 = core.polygonSize( detectedPolys[0] );
      for (i = 0;i < size1;i++) {
        var vertIndex = core.vertexIndex( detectedPolys[0], i );
        indices.push( vertIndex );
        uvs[ vertIndex ] = core.uvCoord( detectedPolys[0], i );
      }
      
      var size2 = core.polygonSize( detectedPolys[1] );
      for (i = 0;i < size2;i++) {
        var vertIndex = core.vertexIndex( detectedPolys[1], i );
        indices.pushUnique( vertIndex );
        uvs[ vertIndex ] = core.uvCoord( detectedPolys[1], i );
      }
      
      //print( 'indices         : ' + indices );
      
      var indices = getVerticesOrder( core, core.normal( detectedPolys[0] ), indices );
      
      //print( 'indices reordered: ' + indices );
      var pindex = core.addIndexPolygon( indices.length, indices );
      if (sel > 0) core.setPolygonSelection( pindex, true );
      
      for (i = 0;i < indices.length;i++) {
        core.setUVCoord( pindex, i, uvs[ indices[i] ] );
      }
      creations.push( indices );
      
      core.deletePolygon( detectedPolys[0] );
      core.deletePolygon( detectedPolys[1] );
      
      loop = true;
      obj.update();
    }
    
    counter++;
    
    /* for debug
    if (counter > 2000) { 
      loop = false;
      print( '-- stop counter: ' + counter );
    }
    */
  }
  
  
  obj.update();
}

Array.prototype.pushUnique = function( e ) {
  if (this.indexOf( e ) === -1) {
    return this.push( e );
  } else {
    return -1;
  }
}