//
//  Polygon2Spline.js
//
//  v.070217 first version. required Cheetah3D version 3.5 ( Edge2Spline.js formally )
//  v.080226 fixed bug, combine Poly2Spline and Edge2Spline, and added new parameters.
//  v.090215 added polygon base ordering option.
//  v.101008 fixed bug for Cheetah3D 5.x
//  v.110202 fixed normalize function bug.
//
//  (c) 2006, 2009 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 
// for scripts/Splineobj Folder

var cache = new Array;
var line_cache = new Array;
var normal_cache = new Array;

var spl_hol = [];
var spl_list = [];
var normal_hol = [];

// for debugging

/*

Vec2D.prototype.toString = function() {
	return this.u.toFixed(4) + ', ' + this.v.toFixed(4);
}
Vec3D.prototype.toString = function() {
	return this.x.toFixed(4) + ', ' + this.y.toFixed(4) + ', ' + this.z.toFixed(4);
}
Vec4D.prototype.toString = function() {
	return this.x.toFixed(4) + ', ' + this.y.toFixed(4) + ', ' + this.z.toFixed(4) + ', ' + this.w.toFixed(4);
}

*/

//

var Vec3D_len = function() {
	if( arguments.length == 1)
		return Math.sqrt( arguments[0].x*arguments[0].x + arguments[0].y*arguments[0].y + arguments[0].z*arguments[0].z );
	var p = arguments[1].sub(arguments[0]);
	return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
}

var Vec3D_normalize = function() {
	var l = arguments[0].norm();
	if( l != 0) 
		return arguments[0].multiply(1/l);
	return arguments[0];
}

/*
if( !Vec3D.len) {
	// returns a Vec3D as a result
	Vec3D.prototype.len = function() {
		if( arguments.length == 0)
			return Math.sqrt( this.x*this.x + this.y*this.y + this.z*this.z );
		var p = arguments[0].sub(this);
		return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
	}
}
if( !Vec3D.normalize) {
	// returns a Vec3D as a result
	Vec3D.prototype.normalize = function() {
		var l = this.norm();
		if( l != 0) 
			return this.multiply(1/l);
		return this;
	}
}

*/

function buildUI(obj) {
	
	obj.setParameter("name","Polygon To Spline");

    obj.addParameterLink("guide target", true);
    obj.addParameterBool("use modified target", 0, 0, 1, true, true);

	obj.addParameterSelector("create type",["all edges","selected edge","polygon selection", "polygon based"],true,true);
	obj.addParameterInt("polygon selection",0,0,15,true,true);

    obj.addParameterBool("connect", 0, 0, 1, true, true);
	
	obj.addParameterSelector("margin type",["distance","percentage"],true,true);
	obj.addParameterFloat("margin",0,-1000,1000,true,true);
	
	obj.addParameterSeparator("Coordinate System");
	
	obj.addParameterSelector("coordinate system",["self","child","world"],true,true);
	//obj.addParameterInt("coordinate system",0,0,1,true,true);
	// in case that you don't use version 3.5.
	
    obj.addParameterSeparator("Wavy");

    obj.addParameterSelector("wave type", [ "none", "sin", "cos" ], true, true );
    obj.addParameterBool("wave start select", 1, 0, 1, true, true);
    obj.addParameterSelector("wave direction", [ "x", "z" ], true, true );
    obj.addParameterFloat("wave detail", 0.25, 0.02, 0.5, true, true);
    obj.addParameterFloat("wave length", 0.1, 0, 10000, true, true);
    obj.addParameterBool("use path length", 0, 0, 1, true, true);
    obj.addParameterFloat("wave height", 0.1, 0, 10000, true, true);
    obj.addParameterFloat("wave offset", 0, -100, 100, true, true);

	obj.addParameterSeparator("Update");
	
	obj.addParameterButton("update object","update","objectUpdate");
}

function objectUpdate(obj) {
	obj.update();
}

function buildObject(obj) {
	var core = obj.core();
	var cType = parseInt(obj.getParameter("create type"));
	var trans = parseInt(obj.getParameter("coordinate system"));
	
    var connect = obj.getParameter("connect");

	var marginType = parseInt(obj.getParameter("margin type"));
	var margin = obj.getParameter("margin");
	
	var selNumStore = 0;
	var selNum = parseInt(obj.getParameter("polygon selection"));

    var waveType = obj.getParameter("wave type");
    var waveDir = obj.getParameter("wave direction");
    var waveDetail = obj.getParameter("wave detail");
    var waveLength = obj.getParameter("wave length");
    var waveUsePathLength = obj.getParameter("use path length");
    var waveHeight = obj.getParameter("wave height");
    var waveOffset = obj.getParameter("wave offset");
    var waveStart = obj.getParameter("wave start select");
	
    if (waveType > 0) {
        if (waveType == 1) {
            var func = function( step, offset, height, normal) { return normal.multiply( Math.sin( Math.PI * step + Math.PI * offset) * height) };
        } else if (waveType == 2) {
            var func = function( step, offset, height, normal) { return normal.multiply( Math.cos( Math.PI * step + Math.PI * offset) * height) };
        }
    }

    var base = obj.getParameter("guide target");

	if (base) {
		var baseMat = base.objMatrix();
		var owMat = base.obj2WorldMatrix();
		var orderCheckNormal = new Vec3D(0, 1, 0);
		
		if (base.family() == NGONFAMILY) {
            if (obj.getParameter("use modified target")) {
                var baseCore = base.modCore();
            } else {
                var baseCore = base.core(); // 
            }
			var basePolyCount = baseCore.polygonCount();
            var i,j;
			
            if (waveStart) {
                var startVertices = [];
                var vertexCount = baseCore.vertexCount();

                for (i = 0;i < vertexCount;i++) {
                    if (baseCore.vertexSelection(i)) {
                        startVertices.push( i );
                    }
                }
            }

			cache.length = 0; // reset spline cache
            line_cache.length = 0;
            normal_cache.length = 0;

			// if create type is polygon selection and object is row polygon object, store active polygon selection.
			if (cType == 2 && base.type() == POLYGONOBJ) selNumStore = base.getParameter("activePolySelection");
			
			switch(cType) {
				case 0: // all edges
					var checkCreation = function(core, i, j) { return true; };
					break;
				case 1: // selected edges
					var checkCreation = function(core, i, j) { return core.edgeSelection(i,j,SELECT); };
					break;
				case 2: // polygon selection
				case 3: // polygon based
					baseCore.setActivePolygonSelection(selNum);
					var checkCreation = function(core, i, j) { return core.polygonSelection(i); };
				    break;
			}
			switch(marginType) {
				case 0: // distance
					var getMargin = function(v1, v2, margin) { return Vec3D_normalize( v2.sub(v1) ).multiply(margin); };
					break;
				case 1: // percentage
					var getMargin = function(v1, v2, margin) { var dist = Vec3D_len(v1,v2); return Vec3D_normalize( v2.sub(v1) ).multiply(dist*margin) };
					break;
			}
			for (i = 0;i < basePolyCount;i++) {
				var bSize = baseCore.polygonSize(i);
				
				if (bSize < 2) continue;
				
				if (cType == 3) {
    				if (checkCreation(baseCore, i, 0)) {
    				    var v1 = baseCore.vertex(baseCore.vertexIndex(i, 0));
    				    if (trans == 1) {
    				        v1 = baseMat.multiply(v1);
    				    }
    				    core.move(v1);
    				    for (j = 1;j < bSize;j++) {
    				        var vs = baseCore.vertex(baseCore.vertexIndex(i,j));
    				        if (trans == 1) {
    				            vs = baseMat.multiply(vs);
    				        }
    				        core.line(vs);
    				    }
    				    core.close();
    				}
				} else {
    				for (j = 0;j < bSize;j++) {
    					if (checkCreation(baseCore, i, j)) {
    						var p1 = j;
    						var p2 = (j+1==bSize)? 0 : j+1;
    						var i1 = baseCore.vertexIndex(i, p1);
    						var i2 = baseCore.vertexIndex(i, p2);
                            var normal1 = baseCore.normal(i, p1);
                            var normal2 = baseCore.normal(i, p2);

    						var cache_d = [i1, i2];
    						cache_d.sort();
    						
                            if (connect) {
                                if (checkCache(cache_d)) {
                                    var isConnected = false;
                                    for(var k = 0;k < line_cache.length;k++) {
                                        var line = line_cache[k];
                                        var normals = normal_cache[k];

                                        if (line[0] == i1 && line.indexOf( i2 ) == -1) {
                                            line.unshift( i2 );
                                            normals.unshift( normal2 );
                                            isConnected = true;
                                        } else if (line[line.length - 1] == i1 && line.indexOf( i2 ) == -1) {
                                            line.push( i2 );
                                            normals.push( normal2 );
                                            isConnected = true;
                                        } else if (line[0] == i2 && line.indexOf( i1 ) == -1) {
                                            line.unshift( i1 );
                                            normals.unshift( normal1 );
                                            isConnected = true;
                                        } else if (line[line.length - 1] == i2 && line.indexOf( i1 ) == -1) {
                                            line.push( i1 );
                                            normals.push( normal1 );
                                            isConnected = true;
                                        } else if (line[0] == i1 && line[line.length-1] == i2) {
                                            line.push( i1 );
                                            normals.push( normal1 );
                                            isConnected = true;
                                        } else if (line[0] == i2 && line[line.length-1] == i1) {
                                            line.push( i2 );
                                            normals.push( normal2 );
                                            isConnected = true;
                                        } else if (line.indexOf(i1) != -1 && line.indexOf(i2) != -1) {
                                            isConnected = true;
                                        }
                                    }
                                    if (isConnected == false) {
                                        line_cache.push( [ i1, i2 ] );
                                        normal_cache.push( [ normal1, normal2 ] );
                                        //print( "push:" + line_cache );
                                    }

                                    cache.push( cache_d );

                                }
                            } else {
        						if (checkCache(cache_d)) {
        							var v1 = baseCore.vertex(i1);
        							var v2 = baseCore.vertex(i2);
        							if (trans == 1) {
        								v1 = baseMat.multiply(v1);
        								v2 = baseMat.multiply(v2);
        							}
        							
        							if (margin != 0.0) {
        								var vm1 = Vec3D_normalize( v2.sub(v1) ).multiply(margin);
        								v1 = v1.add(getMargin(v1, v2, margin));
        								var vm2 = Vec3D_normalize( v1.sub(v2) ).multiply(margin);
        								v2 = v2.add(getMargin(v2, v1, margin));
        							}
        							
        							var orderedVertices = getVertexOrder(orderCheckNormal, [v1, v2]);
        							
        							core.move(orderedVertices[0]);
        							core.line(orderedVertices[1]);
        							
        							cache.push(cache_d);
        						}
                            }
    					}
    				}
				}
			}
			
            if (connect) {
                
                /*
                print( "spline count:" + line_cache.length );
                for(var j = 0;j < line_cache.length;j++) {
                    print( j + ':' + line_cache[j] );
                }
                 */

                while(connectLines() == true) {
                    ;
                }
                
                /*
                print( "spline count:" + line_cache.length );
                for(var j = 0;j < line_cache.length;j++) {
                    print( j + ':' + line_cache[j] );
                }
                 */

                var maxLength = 0;
                if (waveUsePathLength) {
                    for(j = 0;j < line_cache.length;j++) {
                        if (maxLength < line_cache[j].length) {
                            maxLength = line_cache[j].length;
                        }
                    }
                }

                //
                for(j = 0;j < line_cache.length;j++) {
                    var line = line_cache[j];
                    var normals = normal_cache[j];

                    // overlap check...
                    if (line[0] == line[line.length-2] && line[1] == line[line.length-1]) {
                        line.pop();
                        normals.pop();
                    }

                    if (waveStart) {
                        var startIndex = -1;
                        for(ii = 0;ii < startVertices.length;ii++) {
                            startIndex = line.indexOf( startVertices[ii] );
                            if (startIndex > -1) {
                                break;
                            }
                        }

                        if (startIndex != -1) {

                            if (startIndex == line.length-1) {
                                line.reverse();
                                normals.reverse();
                            } else if (startIndex != 0) {
                                if (line[line.length-1] == line[0]) {
                                    var waveLoop = true;
                                    line.pop();
                                    normals.pop();
                                } else {
                                    var waveLoop = false;
                                }
                                var line_new = line.slice(startIndex);
                                line_new = line_new.concat(line.slice(0, line.length - line_new.length));
                                var normals_new = normals.slice(startIndex);
                                normals_new  = normals_new.concat(normals.slice(0, normals.length - normals_new.length));

                                line = line_new;
                                normals = normals_new;

                                if (waveLoop) {
                                    line.push( line[0] );
                                    normals.push( normals[0] );
                                }
                            }
                        }
                    }

                    if (waveType == 0 || waveLength < 0.0001) {

                        for(k = 0;k < line.length;k++) {
                            var v1 = baseCore.vertex(line[k]);
                            if (trans == 1) {
                                v1 = baseMat.multiply(v1);
                            }

                            if (k == 0) {
                                core.move(v1);
                            } else if (k == line.length-1 && line[k] == line[0]) {
                                core.close();
                            } else {
                                core.line(v1);
                            }
                        }

                    } else {

                        if (waveUsePathLength) {

                            var lineOffset = 0; //(maxLength - line.length) * 0.5;

                            for(k = 0;k < line.length;k++) {

                                var normal = normals[k];


                                if (k != line.length-1) {
                                    var segment = Math.floor(1/waveDetail);

                                    var vec1 = baseCore.vertex( line[k]   );
                                    var vec2 = baseCore.vertex( line[k+1] );

                                    for (var l = 0;l < segment;l++) {

                                        var vec = vec1.add( vec2.sub( vec1 ).multiply( waveDetail * l ) );

                                        if (trans == 1) {
                                            vec = baseMat.multiply( vec );
                                        }

                                        var p = func( k + lineOffset + (l * waveDetail), waveOffset, waveHeight, normal );

                                        p = vec.add( p );

                                        if (k == 0 && l == 0) {
                                            core.move( p );
                                        } else {
                                            core.line( p );
                                        }

                                    }
                                } else {
                                    var vec = baseCore.vertex( line[k] );

                                    if (trans == 1) {
                                        vec = baseMat.multiply( vec );
                                    }

                                    var p = func( k + lineOffset, waveOffset + lineOffset, waveHeight, normal );
                                    p = vec.add( p );

                                    if (line[k] == line[0]) {
                                        core.close();
                                        //core.line(p);
                                    } else {
                                        core.line( p );
                                    }
                                }
                            }

                        } else {

                            spl_hol = [];
                            spl_list = [];
                            normal_hol = normals;

                            for (k = 0;k < line.length;k++) {
                                spl_hol.push( baseCore.vertex( line[k] ) );
                            }

                            //print( spl_hol.length + ':' + spl_hol );
                            var pathLength = calcSplineLength( spl_hol, spl_list );
                            var segment = Math.floor( pathLength / waveLength / waveDetail );

                            for (var l = 0;l <= segment;l++) {

                                var vecInfo = pointFromPercentage(spl_hol, spl_list, l/segment);
                                var vec = vecInfo[0];
                                var normal = vecInfo[1];

                                if (trans == 1) {
                                    vec = baseMat.multiply( vec );
                                }

                                var p = func( l * waveDetail, waveOffset, waveHeight, normal);

                                p = vec.add( p );

                                if (l == 0) {
                                    core.move(p);
                                } else {
                                    core.line(p);
                                }
                            }
                        }
                    }

                }
            }

			// if create type is polygon selection and object is row polygon object, stored active polygon selection back.
			if (cType == 2 && base.type() == POLYGONOBJ) base.setParameter("activePolySelection",selNumStore);
		}
	}
}

function connectLines() {

    //print( "connect" );

    var cache = [];
    var n_cache = [];

    var len = line_cache.length;
    for (var i = 0;i < len;i++) {
        var res = false;
        var line = line_cache[i];
        var normals = normal_cache[i];

        var line_len = line.length;
        for (var j = 0;j < len;j++) {
            if (i != j) {
                var line_cmp = line_cache[j];
                var normals_cmp = normal_cache[j];

                var line_cmp_len = line_cmp.length;
                //print( 'cmp:' + line + ' / ' + line_cmp );
                if (line_cmp[0] == line[line_len-2] && line_cmp[1] == line[line_len-1]) {
                    line.pop();line.pop();
                    cache.push( line.concat( line_cmp ) ) ;
                    normals.pop();normals.pop();
                    n_cache.push( normals.concat( normals_cmp ) );

                    res = true;
                } else if (line[0] == line_cmp[line_cmp_len-2] && line[1] == line_cmp[line_cmp_len-1]) {
                    line_cmp.pop();line_cmp.pop();
                    cache.push( line_cmp.concat( line ) );
                    normals_cmp.pop();normals_cmp.pop();
                    n_cache.push( normals_cmp.concat( normals ) );

                    res = true;
                } else if (line_cmp[line_cmp_len-2] == line[line_len-1] && line_cmp[line_cmp_len-1] == line[line_len-2]) {
                    line.pop();line.pop();
                    cache.push( line.concat( line_cmp.reverse() ) );
                    normals.pop();normals.pop();
                    n_cache.push( normals.concat( normals_cmp.reverse() ) );

                    res = true;
                } else if (line_cmp[0] == line[1] && line_cmp[1] == line[0]) {
                    line.reverse();
                    line.pop();line.pop();
                    cache.push( line.concat( line_cmp ));
                    normals.reverse();
                    normals.pop();normals.pop();
                    n_cache.push( normals.concat( normals_cmp ));

                    res = true;
                }

                if (res) {
                    for (var k = i+1;k < len;k++) {
                        if (k != j) {
                            cache.push( line_cache[k] );
                            n_cache.push( normal_cache[k] );
                        }
                    }
                    i = len;
                    j = len;
                }
            }
        }
        if (res == false) {
            cache.push(line);
            n_cache.push(normals);
        }
    }

    var result = (line_cache.length != cache.length)? true : false;

    line_cache = cache;
    normal_cache = n_cache;

    //print( result + ':' + line_cache );

    return result;
}

Array.prototype.toString = function() {
    return "[" + this.join(",") + "]";
}

function checkCache(comp) {
	var i;
	
	for (i = 0;i < cache.length;i++) {
		var cached = cache[i];
		
		if (cached[0] == comp[0] && cached[1] == comp[1]) return false;
	}
	return true;
}

// helper function from Bevel.js
function getVertexOrder(normal, v_list) { // this function doesn't work correctly. :(
	var radian_p = 180/Math.PI;
	var centerVec = v_list[0].add(v_list[1]).multiply(1/2);
	// rotate matrix
	var theta = Math.acos(normal.y)*radian_p;
	var phi = Math.atan2(normal.x, normal.z)*radian_p;
	//print("theta:"+theta+", phi:"+phi);
	var rotMat_a = new Mat4D(ROTATE_HPB, -phi, 0, 0);
	var rotMat_b = new Mat4D(ROTATE_HPB, 0, -theta, 0);
	//
	comp_list = new Array(4);
	for (var i = 0;i < 4;i++) {
		comp_list[i] = new Array;
	}
	//print('v_list: '+v_list);
	//print('centerVec: '+centerVec.toString());
	//print('ss');
	for (var i = 0;i < 2;i++) {
		var vec = v_list[i];
		var comp_vec = rotMat_b.multiply(rotMat_a.multiply(vec.sub(centerVec)));
		var s = Math.atan2(comp_vec.z, comp_vec.x) *180/Math.PI;
		//print('s: '+s);
		if (s > 0) { // 0 - 180
			var new_list = new Array;
			var pushed = false;
			for (j = 0;j < comp_list[0].length;j++) {
				var old_vec = comp_list[0][j];
				if (old_vec[1] < s) {
					new_list.push(old_vec);
				} else {
					if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
					new_list.push(old_vec);
					pushed = true;
				}
			}
			if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
			comp_list[0] = new_list;
		} else { // -180 - 0
			var new_list = new Array;
			var pushed = false;
			for (j = 0;j < comp_list[1].length;j++) {
				var old_vec = comp_list[1][j];
				if (old_vec[1] < s) {
					new_list.push(old_vec);
				} else {
					if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
					new_list.push(old_vec);
					pushed = true;
				}
			}
			if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
			comp_list[1] = new_list;
		}
		//print(comp_vec.toString());
	}
	//print('comp_list: '+comp_list);
	var res_list = new Array;
	for (var i = 0;i < 2;i++) {
		var list = comp_list[i];
		var len = list.length;
		for (var j = 0;j < len;j++) {
			res_list.push(list[j][0]);
		}
	}
	return res_list;
}

//
// these functions from Todd's Loft.js script.
// thank you for sharing, Todd. :D
function calcSplineLength(points,lst) {
    if (!points) {
        lst = [];
        return accum;
    }
    var l = points.length;
    var i;
    var accum = 0;
    lst[0] = 0;
    for(i=0;i<l-1;i++) {
        var p = points[i+1].sub(points[i]);
        accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
        lst[i+1] = accum;
    }
    for(i=0;i<l;i++) {
        lst[i] = lst[i]/accum;
    }
    return accum;
}

// percent must be >= 0 and <= 1
function pointFromPercentage(path,lst,percent) {
    if (!path || path.length < 1) return new Vec3D();
    
    while( percent < 0) percent += 1;
    while( percent > 1) percent -= 1;
    var i,hi = (path)? path.length-1 : 0;
    var lo = 0;
    var d = percent;
    while(hi-lo > 1) {
        i = Math.floor((hi+lo)/2);
        if( percent <= lst[i] ) {
            hi = i;
            continue;
        }
        if( percent > lst[i] ) {
            lo = i;
        }
    }
    i = hi;
            
    var p1 = path[i-1];
    var p2 = path[i];
    // convert d into a percentage between the two points
    d = (d - lst[i-1])/(lst[i] - lst[i-1]);
    p1 = p1.multiply(1-d).add(p2.multiply(d));
    return [p1, normal_hol[i-1] ];
}

