//
//  Edge2Spline.js
//
//  v.070217 first version. required Cheetah3D version 3.5
//
//  v.080226 fixed invert normal problem when using this with Sweep creator.

//  (c) 2006, 2008 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 
// for scripts/Splineobj Folder

var cache = new Array;

// for debugging
Vec2D.prototype.toString = function() {
	return this.u.toFixed(4) + ', ' + this.v.toFixed(4);
}
Vec3D.prototype.toString = function() {
	return this.x.toFixed(4) + ', ' + this.y.toFixed(4) + ', ' + this.z.toFixed(4);
}
Vec4D.prototype.toString = function() {
	return this.x.toFixed(4) + ', ' + this.y.toFixed(4) + ', ' + this.z.toFixed(4) + ', ' + this.w.toFixed(4);
}
//

function buildUI(obj) {
    
    obj.setParameter("name","Edge 2 Spline");
    
    obj.addParameterSeparator("Transform");
    
    obj.addParameterSelector("coordinate system",["self","child"],true,true);
    //obj.addParameterInt("coordinate system",0,0,1,true,true);
    // in case that you don't use version 3.5.
    
    obj.addParameterBool("only selection",0,0,1,true,true);

    obj.addParameterSeparator("Update");
    
    obj.addParameterButton("Update","Update","objectUpdate");
}

function objectUpdate(obj) {
    obj.update();
}

function buildObject(obj) {
    var core = obj.modCore();
    var trans = parseInt(obj.getParameter("coordinate system"));
    var sel = obj.getParameter("only selection");
    
    if (obj.childCount() > 0) {
        var base = obj.childAtIndex(0);
        var baseMat = base.objMatrix();
		var orderCheckNormal = new Vec3D(0, 1, 0);

        if (base.family() == NGONFAMILY) {
            var baseCore = base.core(); // 
            var basePolyCount = baseCore.polygonCount();
            var i,j;
            
            cache.length = 0; // reset spline cache
            
            for (i = 0;i < basePolyCount;i++) {
                var bSize = baseCore.polygonSize(i);
                if (bSize > 1) {
                    for (j = 0;j < bSize;j++) {
                        if (!sel || baseCore.edgeSelection(i,j,SELECT)) {
                            var point1 = j;
                            var point2 = (j+1==bSize)? 0 : j+1;
                            var index_1 = baseCore.vertexIndex(i,point1);
                            var index_2 = baseCore.vertexIndex(i,point2);
                            var cache_d = new Array(index_1,index_2);
                            cache_d.sort();
                            
                            if (checkCache(cache_d)) {
                                var vertex1 = baseCore.vertex(index_1);
                                var vertex2 = baseCore.vertex(index_2);
                                if (trans == 1) {
                                    vertex1 = baseMat.multiply(vertex1);
                                    vertex2 = baseMat.multiply(vertex2);
                                }
                                var orderedVertices = getVertexOrder(orderCheckNormal, [vertex1, vertex2]);
                                
                                core.move(orderedVertices[0]);
                                core.line(orderedVertices[1]);
                                
                                cache.push(cache_d);
                            }
                        }
                    }
                }
            }
        }
    }
}

function checkCache(comp) {
    var i;
    
    for (i = 0;i < cache.length;i++) {
        var cached = cache[i];
        
        if (cached[0] == comp[0] && cached[1] == comp[1]) return false;
    }
    return true;
}

// helper function from Bevel.js
function getVertexOrder(normal, v_list) { // this function doesn't work correctly. :(
	var radian_p = 180/Math.PI;
	var centerVec = v_list[0].add(v_list[1]).multiply(1/2);
	// rotate matrix
	var theta = Math.acos(normal.y)*radian_p;
	var phi = Math.atan2(normal.x, normal.z)*radian_p;
	//print("theta:"+theta+", phi:"+phi);
	var rotMat_a = new Mat4D(ROTATE_HPB, -phi, 0, 0);
	var rotMat_b = new Mat4D(ROTATE_HPB, 0, -theta, 0);
	//
	comp_list = new Array(4);
	for (var i = 0;i < 4;i++) {
		comp_list[i] = new Array;
	}
	//print('v_list: '+v_list);
	//print('centerVec: '+centerVec.toString());
	//print('ss');
	for (var i = 0;i < 2;i++) {
		var vec = v_list[i];
		var comp_vec = rotMat_b.multiply(rotMat_a.multiply(vec.sub(centerVec)));
		var s = Math.atan2(comp_vec.z, comp_vec.x) *180/Math.PI;
		//print('s: '+s);
		if (s > 0) { // 0 - 180
			var new_list = new Array;
			var pushed = false;
			for (j = 0;j < comp_list[0].length;j++) {
				var old_vec = comp_list[0][j];
				if (old_vec[1] < s) {
					new_list.push(old_vec);
				} else {
					if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
					new_list.push(old_vec);
					pushed = true;
				}
			}
			if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
			comp_list[0] = new_list;
		} else { // -180 - 0
			var new_list = new Array;
			var pushed = false;
			for (j = 0;j < comp_list[1].length;j++) {
				var old_vec = comp_list[1][j];
				if (old_vec[1] < s) {
					new_list.push(old_vec);
				} else {
					if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
					new_list.push(old_vec);
					pushed = true;
				}
			}
			if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
			comp_list[1] = new_list;
		}
		//print(comp_vec.toString());
	}
	//print('comp_list: '+comp_list);
	var res_list = new Array;
	for (var i = 0;i < 2;i++) {
		var list = comp_list[i];
		var len = list.length;
		for (var j = 0;j < len;j++) {
			res_list.push(list[j][0]);
		}
	}
	return res_list;
}
