//
// Explosion.js (beta)
//
//  v.080813
//  required version : Cheetah3D v3.6
//
//  (c) 2006-2008 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 2006-01-31 created.
// 2006-02-02 modified something.
// 2006-02-04 bug fix.
// 2007-09-28 change codes for speed and random movements.
// 2008-08-01 fix a problem with v.4.6.1
// 2008-08-13 keep polygon selection of base object.
//
// Usage: Place this into scripts/Polygonobj folder. restart Cheetah3D, then select from Tools -> Scritp -> Polygon Script
//

var randomV = new Array();
var randomX = new Array();
var randomY = new Array();
var randomZ = new Array();

function buildUI(obj){
    var i;
    var normalType, normalAngle;
    
    obj.setParameter("name","Explosion");
    
    obj.addParameterButton("update","Update","objectUpdate");
   
    obj.addParameterSeparator("Explosion");
    obj.addParameterFloat("core x", 0, -1000, 1000, true, true);
    obj.addParameterFloat("core y", 0, -1000, 1000, true, true);
    obj.addParameterFloat("core z", 0, -1000, 1000, true, true);
    
    obj.addParameterFloat("core value", 0, -1.0, 1.0, true, true);
    obj.addParameterFloat("core size", 1, 0, 100, true, true);
    
    obj.addParameterBool("keep smooth",0,0,1,true,true);
    
    obj.addParameterSeparator("Randomize");
    
    obj.addParameterFloat("random x", 0, -3600, 3600, true, true);
    obj.addParameterFloat("random y", 0, -3600, 3600, true, true);
    obj.addParameterFloat("random z", 0, -3600, 3600, true, true);

    obj.addParameterFloat("rotation min", 0, -3600, 3600, true, true);
    obj.addParameterFloat("rotation max", 0, -3600, 3600, true, true);
    
    obj.addParameterSeparator("Smooth"); // normal type
    obj.addParameterSelector("smooth",["flat","phong","constraint"],true,true);
    obj.addParameterFloat("smooth angle",45,1,180,true,true);
    
    obj.setParameter("smooth",2);
}

function setRandoms(count) {

    //print("--- setRandoms ---");
    //print("count: "+count);
    for (i = 0;i < count;i++) {
        randomV[i] = Math.random() * -0.5;
        randomX[i] = Math.random() * -0.5;
        randomY[i] = Math.random() * -0.5;
        randomZ[i] = Math.random() * -0.5;        
    }
}

function objectUpdate(obj) {
    obj.update();
}

function buildObject(obj){
    var core = obj.core();
    
    obj.setParameter("normalType",obj.getParameter("smooth"),false);
    obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);

    var expVt = obj.getParameter("core value");
    var expCenter = new Vec3D(obj.getParameter("core x"),obj.getParameter("core y"),obj.getParameter("core z"));
    var areaRound = obj.getParameter("core size");
    var rotMin = obj.getParameter("rotation min");
    var rotVt = obj.getParameter("rotation max");
    var randX = obj.getParameter("random x");
    var randY = obj.getParameter("random y");
    var randZ = obj.getParameter("random z");
    var keepSmooth = (obj.getParameter("keep smooth"))? true : false;
    
    //print("------ Explosion ------");
    
    //print(expCenter.x + ':' + expCenter.y + ':' + expCenter.z);
    //print('norm:'+expCenter.norm());
    //print('a*vt:'+areaRound * expVt);
    if (obj.childCount() > 0) {
        var base;
        var i, j;
        base = obj.childAtIndex(0);
        
        if (base.family() == NGONFAMILY) {
            var baseCore = base.modCore();
            var basePolyCount = baseCore.polygonCount();
            
            if (randomV.length < basePolyCount) {
                setRandoms(basePolyCount);
            }
            
            for (i = 0;i < basePolyCount;i++) {
                var basePolySize = baseCore.polygonSize(i);

                var Verts = new Array;
                var UVs = new Array;
                var IndexPolygon = new Array;
                
                var polyVec = new Vec3D(0,0,0);
                for (j = 0;j < basePolySize;j++) { // store vertex and uv info to Verts, UVs 
                    
                    Verts[j] = baseCore.vertex(baseCore.vertexIndex(i,j));
					UVs[j] = baseCore.uvCoord(i,j);
                    
                    polyVec = polyVec.add(Verts[j]);
                    //print(Verts[j].x+':'+Verts[j].y+':'+Verts[j].z);                    
                }
                //calculate each polygon center
                polyVec = polyVec.multiply(1/basePolySize);
                //print(polyVec.x+':'+polyVec.y+':'+polyVec.z);
                //calculate value
                //maybe mistake..... I am not sure this culclation....
                var sp = Math.sqrt(Math.pow(expCenter.x - polyVec.x, 2) + Math.pow(expCenter.y - polyVec.y, 2) +Math.pow(expCenter.z - polyVec.z, 2));
                //print('sp1:'+sp);
                if (sp > 0) {
                    sp = expVt * areaRound / sp;
                }
                //print(sp);
                var moveVec = polyVec.multiply(2).sub(expCenter).multiply(sp*sp);
                var movedVec = polyVec.add(moveVec);
                //
                var rotRandom = randomV[i];
                var mt = sp * expVt;
                var rotation = (rotMin + rotRandom*rotVt) * mt;
                var randMov = new Vec3D(randomX[i]*randX*mt, randomY[i]*randY*mt, randomZ[i]*randZ*mt);
                //
                var rotMatrix = new Mat4D(ROTATE, rotation, rotation, 0);
                for (j = 0;j < basePolySize;j++) {
                		IndexPolygon[j] = core.addVertex(keepSmooth, 
                			randMov.add(movedVec.add(rotMatrix.multiply(Verts[j].sub(polyVec)))));
                }
                //

                var p_index = core.addIndexPolygon(basePolySize, IndexPolygon);
                for (var j = 0;j < basePolySize;j++) {
                	core.setUVCoord(p_index, j, UVs[j]);
                }
                //
                for (var j = 0;j < 16;j++) {
                	baseCore.setActivePolygonSelection(j);
                	core.setActivePolygonSelection(j);
                	core.setPolygonSelection(p_index, baseCore.polygonSelection(i));
                }
            }
            baseCore.setActivePolygonSelection(0);
        }
    }
}



