// Bevel.js
// still buggy...

// Vec3D extension - from Todd's script
//

/*
Vec3D.prototype.toString = function() {
    return "(" + this.x.toFixed(4) + ", " + this.y.toFixed(4) + ", " + this.z.toFixed(4) + ")";
}
if( !Vec3D.len) {
    // returns a Vec3D as a result
    Vec3D.prototype.len = function() {
        if( arguments.length == 0)
            return Math.sqrt( this.x*this.x + this.y*this.y + this.z*this.z );
        var p = arguments[0].sub(this);
        return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
    }
}
if( !Vec3D.normalize) {
    // returns a Vec3D as a result
    Vec3D.prototype.normalize = function() {
        var l = this.norm();
        if( l != 0) 
            return this.multiply(1/l);
        return this;
    }
}
if( !Vec3D.dot) {
    Vec3D.prototype.dot = function(other) {
        return this.x*other.x + this.y*other.y + this.z*other.z;
    }
}
if( !Vec3D.cross) {
    // returns a Vec3D as a result
    Vec3D.prototype.cross = function(other) {
        var xh = this.y * other.z - other.y * this.z;
        var yh = this.z * other.x - other.z * this.x;
        var zh = this.x * other.y - other.x * this.y;
        return new Vec3D(xh,yh,zh);
    }
}
*/

var Vec3D_len = function() {
  if( arguments.length == 1)
      return Math.sqrt( arguments[0].x*arguments[0].x + arguments[0].y*arguments[0].y + arguments[0].z*arguments[0].z );
  var p = arguments[1].sub(arguments[0]);
  return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
}

var Vec3D_normalize = function() {
  var l = arguments[0].norm();
  if ( l != 0 ) {
    return arguments[0].multiply(1/l);
  }
  return arguments[0];
}

// Array extension
Array.prototype.pushUnique = function(val) {
    var len = this.length;
    var res = true;
    for (var i = 0;i < len;i++) {
        if (this[i] == val) res = false;
    }
    if (res && val != null) this[len] = val;
}

// Edge Class
function EdgeObj(p1, p2, p1_ta, p2_ta, p1_weight, p2_weight) {
    this.p1 = p1;
    this.p2 = p2; // original point index of edge side
    this.p1_ta = p1_ta;
    this.p1_tb = null;
    this.p2_ta = p2_ta;
    this.p2_tb = null; // original target point index for making bevel
    this.p1_ca = null;
    this.p1_cb = null;
    this.p2_ca = null;
    this.p2_cb = null; // 
    this.p1_weight = p1_weight;
    this.p2_weight = p2_weight; // side point's wieght
    this.p1_mod = false;
    this.p2_mod = false;
    this.f1 = null;
    this.f2 = null; // original polygon index of edge made by
    this.f1_p1 = false;
    this.f1_p2 = false;
    this.f2_p1 = false;
    this.f2_p2 = false;
    this.normal = null; // edge normal
    this.beveled = false; // bevel frag
    this.flipped = false;
}
EdgeObj.prototype.toString = function() {
    return 'e: '+this.p1+' ('+this.p1_ta+','+this.p1_tb+','+this.p1_ca+','+this.p1_cb+'), '
            +this.p2+' ('+this.p2_ta+','+this.p2_tb+','+this.p2_ca+','+this.p2_cb+'), ' + this.beveled
            +"\n"+'   p1_weight: '+this.p1_weight+', p2_weight: '+this.p2_weight+', f1: '+this.f1+', f2: '+this.f2;
}
EdgeObj.prototype.calcNormal = function(core) {
    var n1 = core.normal(this.f1);
    if (this.f2 != null) {
        var n2 = core.normal(this.f2);
        this.normal = Vec3D_normalize( n1.add(n2) );
    } else {
        this.normal = n1;
    }
}
// Corner Class
function CornerObj(p_index, p_weight, e1, e2, f1, f2) {
    this.p_index = p_index; // original point index
    this.p_weight = p_weight; // corner weight
    this.e_list = new Array;
    this.f_list = new Array;
    this.c_list = new Array;
    this.r_center = null;
    this.r_radius = null;
    if (e1 != null) this.e_list.push(e1);
    if (e2 != null) this.e_list.push(e2); // added point index list
    if (e1 != null) this.f_list.push(f1);
    if (e2 != null) this.f_list.push(f2); // original polygon index on which added points
    this.normal = null;
}
CornerObj.prototype.addIndex = function(e1, e2, f1, f2) {
    if (e1 != null) {
        this.e_list.push(e1);
        this.f_list.push(f1);
    }
    if (e2 != null) {
        this.e_list.push(e2);
        this.f_list.push(f2);
    }
}
CornerObj.prototype.addNormal = function(normal) {
    this.normal = Vec3D_normalize( this.normal.add(normal) );
}
CornerObj.prototype.getCornerList = function() {
    var list = new Array;
    var len = this.e_list.length;
    for (var i = 0;i < len;i++) {
        list.pushUnique(this.e_list[i]);
    }
    return list;
}
CornerObj.prototype.getVertexIndex = function(i) {
    var f_len = this.f_list.length;
    var list = new Array;
    for (var ii = 0;ii < f_len;ii++) {
        if (this.f_list[ii] == i) {
            list.pushUnique(this.e_list[ii]);
        }
    }
    if (list.length < 1) {
        //print('p_index: '+this.p_index+', f: '+i);
        if (this.e_list[0] != this.e_list[1]) {
            //return this.e_list;
            for (var ii = 0;ii < f_len;ii++) {
                if (this.f_list[ii] == -1) {
                    list.pushUnique(this.e_list[ii]);
                }
            }
            var c_len = this.c_list.length;
            for (ii = 0;ii < c_len;ii++) {
                list.pushUnique(this.c_list[ii]);
            }
            return list;
        } else {
            print('CornerObj.getVertexIndex - not exists vertices indeices.');
            return [this.e_list[0]]; // not exists data, return [0] data
        }
    } else {
        return list;
    }
}
CornerObj.prototype.addFaceIndex = function(val) {
    this.c_list.push(val);
}
CornerObj.prototype.getFaceList = function() {
    var e_len = this.e_list.length;
    var res_list = new Array;
    for (var i = 0;i < e_len;i++) { // only unique index value
        res_list.pushUnique(this.e_list[i]);
    }
    //
    if (res_list.length > 2) {
        var c_len = this.c_list.length;
        for (ii = 0;ii < c_len;ii++) {
            res_list.pushUnique(this.c_list[ii]);
        }
    }
    return res_list;
}
CornerObj.prototype.toString = function() {
    return 'c: index:'+this.p_index+', weight:'+this.p_weight+', e:('+this.e_list+'), f:('+this.f_list+')';
}
// helper function
function getVertexOrder(core, normal, v_list) { // this function doesn't work correctly. :(
    var v_len = v_list.length;
    if( v_len < 1) return new Array;
    var centerVec = core.vertex(v_list[0]);
    var radian_p = 180/Math.PI;
    for (var i = 1;i < v_len;i++) {
        centerVec = centerVec.add(core.vertex(v_list[i]));
    }
    centerVec = centerVec.multiply(1/v_len); // calc center point
    // rotate matrix
    var theta = Math.acos(normal.y)*radian_p;
    var phi = Math.atan2(normal.x, normal.z)*radian_p;
    //print("theta:"+theta+", phi:"+phi);
    var rotMat_a = new Mat4D(ROTATE_HPB, -phi, 0, 0);
    var rotMat_b = new Mat4D(ROTATE_HPB, 0, -theta, 0);
    //
    comp_list = new Array();
    for (var i = 0;i < 2;i++) {
        comp_list[i] = new Array;
    }
    //print('v_list: '+v_list);
    //print('centerVec: '+centerVec.toString());
    //print('ss');
    for (var i = 0;i < v_len;i++) {
        var vec = core.vertex(v_list[i]);
        var comp_vec = rotMat_b.multiply(rotMat_a.multiply(vec.sub(centerVec)));
        var s = Math.atan2(comp_vec.z, comp_vec.x) *180/Math.PI;
        //print('s: '+s);
        if (s > 0) { // 0 - 180
            var new_list = new Array;
            var pushed = false;
            for (j = 0;j < comp_list[0].length;j++) {
                var old_vec = comp_list[0][j];
                if (old_vec[1] < s) {
                    new_list.push(old_vec);
                } else {
                    if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
                    new_list.push(old_vec);
                    pushed = true;
                }
            }
            if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
            comp_list[0] = new_list;
        } else { // -180 - 0
            var new_list = new Array;
            var pushed = false;
            for (j = 0;j < comp_list[1].length;j++) {
                var old_vec = comp_list[1][j];
                if (old_vec[1] < s) {
                    new_list.push(old_vec);
                } else {
                    if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
                    new_list.push(old_vec);
                    pushed = true;
                }
            }
            if (pushed == false) new_list.push([v_list[i], s, comp_vec]);
            comp_list[1] = new_list;
        }
        //print(comp_vec.toString());
    }
    //print('comp_list: '+comp_list);
    var res_list = new Array;
    for (var i = 0;i < 2;i++) {
        var list = comp_list[i];
        var len = list.length;
        for (var j = 0;j < len;j++) {
            res_list.push(list[j][0]);
        }
    }
    return res_list;
}

//
function buildUI(obj) {
    obj.setParameter("name","Bevel");
    
    obj.addParameterFloat("bevel radius",0.05,0,1000,true,true);
    obj.addParameterInt("bevel detail",1,1,64,true,true);
    obj.addParameterBool("bevel flipped", 0, 0, 1, true, true);
    obj.addParameterBool("only edge selection",1,0,1,true,true);
    obj.addParameterBool("make as Creator", 0, 0, 1, true, true);
    obj.addParameterButton("Update","Update","updateObj");
    
    obj.addParameterSeparator("Geometry Management");
    obj.addParameterButton("take child's geometry","apply","takeChildMatrix");
    
    //
    obj.addParameterSeparator("Smooth");
    obj.addParameterSelector("smooth",["flat","phong","constraint"],true,true);
    obj.addParameterFloat("smooth angle", 45.0, 5.0, 90.0, true, true);
    
    obj.setParameter("smooth",2);
}

function updateObj(obj) {
    obj.update();
}

function takeChildMatrix(obj) {
    var child = obj.childAtIndex(0);
    
    var pos = child.getParameter("position");
    var scale = child.getParameter("scale");
    var rot = child.getParameter("rotation");
    
    if (pos.x != 0 || pos.y != 0 || pos.z != 0) {
        child.setParameter("position", new Vec3D(0,0,0));
        obj.setParameter("position", pos);
    }
    if (scale.x != 1 || scale.y != 1 || scale.z != 1) {
        child.setParameter("scale", new Vec3D(1,1,1));
        obj.setParameter("scale", scale);
    }
    
    if (rot.x != 0 || rot.y != 0 || rot.z != 0) {
        child.setParameter("rotation", new Vec3D(0,0,0));
        obj.setParameter("rotation", rot);
    }
}

function buildObject(obj) {
    var radius = obj.getParameter("bevel radius");
    var detail = obj.getParameter("bevel detail");
    var flipped = obj.getParameter("bevel flipped");
    //
    //var detail = 1;
    var onlySel = obj.getParameter("only edge selection");
    //
    var make_as_creator = obj.getParameter("make as Creator");
    
    var norm1, norm2, norm3;
    
    //print('--Bevel--'+"\n"+'radius: '+radius.toFixed(4));
    // smooth
    obj.setParameter("normalType",obj.getParameter("smooth"),false);
    obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
    //
    var core = obj.core();
    
    if (obj.childCount() > 0) {
        var child = obj.childAtIndex(0);
        
        obj.setCreatorObj(make_as_creator? true : false);
        
        if (child.family() == NGONFAMILY) {
            var c_core = child.core();
            var edges = new Array;
            var corners = new Array;
            
            var cornerStep = Math.PI/2/detail;
            
            var pCount = c_core.polygonCount();
            
            // 頂点からコーナーオブジェクトをキャッシュ
            var vCount = c_core.vertexCount();
            for (var i = 0;i < vCount;i++) {
                corners[i] = new CornerObj(i, 0, null, null, null, null);
            }
            // collect edge.
            // creating edge object.
            for (var i = 0;i < pCount;i++) {
                var pSize = c_core.polygonSize(i);
                for (var j = 0;j < pSize;j++) {
                    var p1 = c_core.vertexIndex(i,j);
                    var p2 = (j+1 == pSize)? c_core.vertexIndex(i,0):c_core.vertexIndex(i,j+1);
                    // calc target points
                    var p1t_d = (j == 0)? pSize-1:j-1;
                    var p1t = c_core.vertexIndex(i,p1t_d);
                    if (j+1 == pSize) var p2t_d = 1;
                    else if (j+2 == pSize) var p2t_d = 0;
                    else var p2t_d = j+2;
                    var p2t = c_core.vertexIndex(i,p2t_d);
                    //
                    // 重複したエッジを検索し、登録済みの場合情報を更新
                    var e_len = edges.length;
                    var res = true;
                    for (var ii = 0;ii < e_len;ii++) {
                        var edge = edges[ii];
                        if (edge.p2 == p1 && edge.p1 == p2) {
                            res = false;
                            edge.p1_weight++;
                            edge.p2_weight++;
                            edge.p1_tb = p2t; // swap...
                            edge.p2_tb = p1t; // swap...
                            edge.f2 = i;
                        }
                    }
                    if (res) {
                        var edge = new EdgeObj(p1, p2, p1t, p2t, 1, 1);
                        edge.f1 = i;
                        // if edge is selected
                        if (onlySel == false || c_core.edgeSelection(i,j,SELECT)) edge.beveled = true;
                        if (c_core.edgeSelection(i,j,CREASE)) edge.flipped = true;
                        edges.push(edge);
                    }
                }
            }
            // ポイントの重みを再計算
            // re-collect point weight.
            for (var i = 0;i < pCount;i++) {
                var pSize = c_core.polygonSize(i);
                for (var j = 0;j < pSize;j++) {
                    var p1 = c_core.vertexIndex(i,j);
                    var p2 = (j+1 == pSize)? c_core.vertexIndex(i,0):c_core.vertexIndex(i,j+1);
                    //
                    //
                    var p1t_d = (j == 0)? pSize-1:j-1;
                    var p1t = c_core.vertexIndex(i,p1t_d);
                    if (j+1 == pSize) var p2t_d = 1;
                    else if (j+2 == pSize) var p2t_d = 0;
                    else var p2t_d = j+2;
                    var p2t = c_core.vertexIndex(i,p2t_d);
                    //
                    // other target point.
                    var e_len = edges.length;
                    var beveled = c_core.edgeSelection(i,j,SELECT);
                    for (var ii = 0;ii < e_len;ii++) {
                        var edge = edges[ii];
                        if (onlySel == false || beveled) {
                            if (edge.beveled == true) { // selected and beveled
                                if ((edge.p1 == p1 && edge.p2 == p2) || (edge.p1 == p2 && edge.p2 == p1)) {
                                    ; // do nothing. this is same edge.
                                } else {
                                    if (edge.p1 == p1 || edge.p1 == p2) {
                                        edge.p1_weight++;
                                    }
                                    if (edge.p2 == p1 || edge.p2 == p2) {
                                        edge.p2_weight++;
                                    }
                                    if (edge.f1 == i) {
                                        if (edge.p1 == p1) edge.p1_ca = p1t;
                                        if (edge.p1 == p2) edge.p1_ca = p2t;
                                        if (edge.p2 == p1) edge.p2_ca = p1t;
                                        if (edge.p2 == p2) edge.p2_ca = p2t;
                                    }
                                    if (edge.f2 == i) {
                                        if (edge.p1 == p1) edge.p1_cb = p1t;
                                        if (edge.p1 == p2) edge.p1_cb = p2t;
                                        if (edge.p2 == p1) edge.p2_cb = p1t;
                                        if (edge.p2 == p2) edge.p2_cb = p2t;
                                    }
                                }
                            } else { // selected and normal edge
                                if ((edge.p1 == p1 && edge.p2 == p2) || (edge.p1 == p2 && edge.p2 == p1)) {
                                    ; // do nothing. this is same edge.
                                } else {
                                    if (edge.p1 == p1 || edge.p1 == p2) {
                                        edge.p1_mod = true;
                                    }
                                    if (edge.p2 == p1 || edge.p2 == p2) {
                                        edge.p2_mod = true;
                                    }
                                }
                            }
                        }
                        //print(edge.toString());
                    }
                }
            }
            var e_len = edges.length;
            // adding points
            //print('e_len: '+e_len);
            for (var i = 0;i < e_len;i++) {
                var edge = edges[i];
                var radian_p = 180/Math.PI;
                // calc normal
                edge.calcNormal(c_core);
                // 
                var po1 = c_core.vertex(edge.p1);
                var po1_ta = c_core.vertex(edge.p1_ta);
                if (edge.p1_tb != null) var po1_tb = c_core.vertex(edge.p1_tb);
                else var po1_tb = null; // 1 face
                //
                var po2 = c_core.vertex(edge.p2);
                var po2_ta = c_core.vertex(edge.p2_ta);
                if (edge.p2_tb != null) var po2_tb = c_core.vertex(edge.p2_tb);
                else var po2_tb = null; // 1 face
                //
                var corner1 = corners[edge.p1];
                var corner2 = corners[edge.p2];
                if (edge.beveled) { // beveled
                    // calc extra target point
                    if (edge.p1_ca != null) { //
                        var po1_ca = c_core.vertex(edge.p1_ca);
                        norm1 = Vec3D_normalize(po1_ca.sub(po1));
                        norm2 = Vec3D_normalize(po1_ta.sub(po1));
                        var point1a = norm1.add( norm2 ).multiply(radius).add(po1);
                        //print(point1a.toString());
                    } else {
                        norm1 = Vec3D_normalize( po1_ta.sub(po1) );
                        var point1a = norm1.multiply(radius).add(po1);
                        //print('1a:'+edge.p1+','+edge.p1a);
                    }
                    if (edge.f2 != null) {
                        if (edge.p1_cb != null) { 
                            var po1_cb = c_core.vertex(edge.p1_cb);
                            norm1 = Vec3D_normalize( po1_cb.sub(po1) );
                            norm2 = Vec3D_normalize( po1_tb.sub(po1) );
                            var point1b = norm1.add( norm2 ).multiply(radius).add(po1);
                            //print(point1b.toString());
                        } else {
                            norm1 = Vec3D_normalize( po1_tb.sub(po1) );
                            var point1b = norm1.multiply(radius).add(po1);
                            //print('1b:'+edge.p1+','+edge.p1b);
                        }
                    }
                    //
                    if (edge.p2_ca != null) {
                        var po2_ca = c_core.vertex(edge.p2_ca);
                        norm1 = Vec3D_normalize( po2_ca.sub(po2) );
                        norm2 = Vec3D_normalize( po2_ta.sub(po2) );
                        var point2a = norm1.add( norm2 ).multiply(radius).add(po2);
                        //print(point2a.toString());
                    } else {
                        norm1 = Vec3D_normalize( po2_ta.sub(po2) );
                        var point2a = norm1.multiply(radius).add(po2);
                    }
                    if (edge.f2 != null) {
                        if (edge.p2_cb != null) {
                            var po2_cb = c_core.vertex(edge.p2_cb);
                            norm1 = Vec3D_normalize( po2_cb.sub(po2) );
                            norm2 = Vec3D_normalize( po2_tb.sub(po2) );
                            var point2b = norm1.add( norm2 ).multiply(radius).add(po2);
                            //print(point2b.toString());
                        } else {
                            norm1 = Vec3D_normalize( po2_tb.sub(po2) );
                            var point2b = norm1.multiply(radius).add(po2);
                        }
                    }
                    // adding points and storing vertex index.
                    var t1_a = core.addVertex(true, point1a);
                    if (edge.f2 != null) var t1_b = core.addVertex(true, point1b);
                    else var t1_b = core.addVertex(true, c_core.vertex(edge.p1));
                    var t2_a = core.addVertex(true, point2a);
                    if (edge.f2 != null) var t2_b = core.addVertex(true, point2b);
                    else var t2_b = core.addVertex(true, c_core.vertex(edge.p2));
                    //
                    var t1_ex = null;
                    var t2_ex = null;
                    // add polygon
                    //print('e: '+[t1_a, t1_b, t2_b, t2_a]);
                    if (detail > 1 && edge.f2 != null) {
                        var c1_norm = c_core.normal(edge.f1);
                        var c2_norm = c_core.normal(edge.f2);
                        //
                        var c_cross = Vec3D_normalize( c1_norm.cross(c2_norm) );
                        var c_dot = c1_norm.dot(c2_norm);
                        c_dot = (c_dot.norm)? c_dot.x : c_dot;
                        var c_cosT = c_dot / (Vec3D_len( c1_norm ) * Vec3D_len( c2_norm ));
                        //
                        //print('round edge:');
                        var point1d = point1a.add(point1b).multiply(1/2);
                        var point2d = point2a.add(point2b).multiply(1/2);
                        //
                        //print('point1d: '+point1d.toString());
                        //print('point2d: '+point2d.toString());
                        var c_normal = Vec3D_normalize( c1_norm.add(c2_norm) );
                        //var c_normal1 = po1.sub(point1d).normalize();
                        //var c_normal2 = po2.sub(point2d).normalize();
                        var c_normal1 = c_normal;
                        var c_normal2 = c_normal;
                        
                        //print('c_normal: '+c_normal.toString());
                        var point1_ad = point1d.sub(point1a);
                        var point2_ad = point2d.sub(point2a);
                        //print('c_cross: '+c_cross.toString());
                        var c_theta = Math.acos(c_cosT);
                        var c_angle = c_theta*radian_p;
                        var c_tan = Math.tan(c_theta/2);
                        if ((flipped && edge.flipped == false) || (flipped == false && edge.flipped)) {
                            //print('angle minus:');
                            //var cornerSteps = c_theta/detail;
                            //var p1_center = point1a.add(c1_norm.multiply(-radius));
                            //var p2_center = point2a.add(c1_norm.multiply(-radius));
                            var p1_center = point1d.add(c_normal1.multiply(Vec3D_len( point1_ad )/c_tan)); //point1a.add(point1b).sub(po1_cen);
                            var p2_center = point2d.add(c_normal2.multiply(Vec3D_len( point2_ad )/c_tan)); //point2a.add(point2b).sub(po2_cen);
                        } else {
                            //print('angle plus:');
                            //var cornerSteps = -c_theta/detail;
                            //var p1_center = point1a.add(c1_norm.multiply(-radius));
                            //var p2_center = point2a.add(c1_norm.multiply(-radius));
                            var p1_center = point1d.sub(c_normal1.multiply(Vec3D_len( point1_ad )/c_tan)); //point1a.add(point1b).sub(po1_cen);
                            var p2_center = point2d.sub(c_normal2.multiply(Vec3D_len( point2_ad )/c_tan)); //point2a.add(point2b).sub(po2_cen);
                        }
                        var norm_1a = Vec3D_normalize( point1a.sub(p1_center) ); // starting vector.
                        var norm_1b = Vec3D_normalize( norm_1a.cross(point1a.sub(point2a)) );
                        var norm_2a = Vec3D_normalize( point2a.sub(p2_center) ); // starting vector.
                        var norm_2b = Vec3D_normalize( norm_2a.cross(point1a.sub(point2a)) );
                        //
                        var c_radius1 = Vec3D_len( point1a.sub(p1_center) );
                        var c_radius2 = Vec3D_len( point2a.sub(p2_center) );
                        //
                        // add polygon for checking center points.
                        //core.addPolygon(3, true, [p1_center, point1b, point1a]);
                        //core.addPolygon(3, true, [p2_center, point2b, point2a]);
                        
                        //print('c_angle: '+c_angle.toFixed(4));
                        //print('c_theta: '+c_theta.toFixed(4));
                        //print('c_tan: '+c_tan.toFixed(4));
                        //print('c_radius1: '+c_radius1.toFixed(3));
                        //print('c_radius2: '+c_radius2.toFixed(3));
                        //print('p1_center: '+p1_center);
                        //print('p2_center: '+p2_center);
                        //
                        if (corner1.r_center != null) corner1.r_center = corner1.r_center.add(p1_center).multiply(1/2);
                        else corner1.r_center = p1_center;
                        if (corner2.r_center != null) corner2.r_center = corner2.r_center.add(p2_center).multiply(1/2);
                        else corner2.r_center = p2_center;
                        
                        corner1.r_radius = c_radius1;
                        corner2.r_radius = c_radius2;
                        //
                        if (c_theta.toFixed(2) == 0 || c_theta == Math.PI) { // 0 or 180 degree
                            var norm_s1 = point1b.sub(point1a);
                            var norm_s2 = point2b.sub(point2a);
                            var ct1_b = core.addVertex(true, point1a);
                            var ct2_b = core.addVertex(true, point2a);
                            for (var jj = 1;jj < detail;jj++) {
                                var a = (1 / detail) * jj;
                                var ct1 = point1a.add(norm_s1.multiply(a));
                                var ct2 = point2a.add(norm_s2.multiply(a));
                                var ct1_a = core.addVertex(true, ct1);
                                var ct2_a = core.addVertex(true, ct2);
                                core.addIndexPolygon(4, [ct2_a, ct2_b, ct1_b, ct1_a]); //[ct1_a, ct1_b, ct2_b, ct2_a]); // reversed
                                corner1.addFaceIndex(ct1_a);
                                corner2.addFaceIndex(ct2_a);
                                ct1_b = ct1_a;
                                ct2_b = ct2_a;
                            }
                            ct1_a = core.addVertex(true, point1b);
                            ct2_a = core.addVertex(true, point2b);
                            core.addIndexPolygon(4, [ct2_a, ct2_b, ct1_b, ct1_a]);
                        } else {
                            var ct1_b = core.addVertex(true, point1a);
                            var ct2_b = core.addVertex(true, point2a);
                            for (var jj = 1;jj < detail;jj++) {
                                //var dj = jj * cornerSteps;
                                //var dj_angle = dj * radian_p;
                                //print('dj:'+dj_angle.toFixed(1));
                                
                                //var a1 = c_radius1 * Math.cos(dj);
                                //var a2 = c_radius2 * Math.cos(dj);
                                //var b1 = c_radius1 * Math.sin(dj);
                                //var b2 = c_radius2 * Math.sin(dj);
                                //var ct1 = p1_center.add(norm_1a.multiply(a1)).add(norm_1b.multiply(b1));
                                //var ct2 = p2_center.add(norm_2a.multiply(a2)).add(norm_2b.multiply(b2));
                                //
                                var ct_1e = point1a.multiply((detail-jj)/detail).add(point1b.multiply(jj/detail));
                                var ct_2e = point2a.multiply((detail-jj)/detail).add(point2b.multiply(jj/detail));
                                norm1 = Vec3D_normalize( ct_1e.sub(p1_center) );
                                norm2 = Vec3D_normalize( ct_2e.sub(p2_center) );
                                var ct1 = norm1.multiply(c_radius1).add(p1_center);
                                var ct2 = norm2.multiply(c_radius2).add(p2_center);
                                //
                                var ct1_a = core.addVertex(true, ct1);
                                var ct2_a = core.addVertex(true, ct2);
                                //print('p: '+[ct2_a, ct2_b, ct1_b, ct1_a]);
                                core.addIndexPolygon(4, [ct2_a, ct2_b, ct1_b, ct1_a]); //[ct1_a, ct1_b, ct2_b, ct2_a]); // reversed
                                corner1.addFaceIndex(ct1_a);
                                corner2.addFaceIndex(ct2_a);
                                ct1_b = ct1_a;
                                ct2_b = ct2_a;
                            }
                            ct1_a = core.addVertex(true, point1b);
                            ct2_a = core.addVertex(true, point2b);
                            core.addIndexPolygon(4, [ct2_a, ct2_b, ct1_b, ct1_a]);
                        }
                    } else {
                        core.addIndexPolygon(4, [t1_a, t1_b, t2_b, t2_a]);
                    }
                } else { // normal edge
                    //
                    var t1_a = null;
                    var t1_b = null;
                    var t2_a = null;
                    var t2_b = null;
                    var t1_ex = null;
                    var t2_ex = null;
                    if (edge.p1_mod != true) {
                        var point1a = c_core.vertex(edge.p1);
                        if (edge.f2 != null) var point1b = point1a;
                        var t1_a = core.addVertex(true, point1a);
                        if (edge.f2 != null) var t1_b = core.addVertex(true, point1b);
                        else var t1_b = null;
                    } else if (edge.f2 != null) {
                        var c1_norm = c_core.normal(edge.f1);
                        var c2_norm = c_core.normal(edge.f2);
                        var c_cross = c1_norm.cross(c2_norm);
                        var c_dot = c1_norm.dot(c2_norm);
                        c_dot = (c_dot.norm)? c_dot.x : c_dot;
                        var c_cosT = c_dot / (Vec3D_len( c1_norm ) * Vec3D_len( c2_norm ));
                        //print('c_cross: '+c_cross.toString());
                        //print('c_angle: '+Math.acos(c_cosT)*radian_p);
                        if (false && c_cross.x < 0) {
                            //print('add_extra for p1');
                            norm1 = Vec3D_normalize( po1_ta.sub(po1) );
                            var point1a = norm1.multiply(radius).add(po1);
                            if (edge.f2 != null) {
                                norm2 = Vec3D_normalize( po1_tb.sub(po1) );
                                var point1b = norm2.multiply(radius).add(po1);
                            }
                            t1_a = core.addVertex(true, point1a);
                            if (edge.f2 != null) t1_b = core.addVertex(true, point1b);
                            //
                            norm3 = Vec3D_normalize( po2.sub(po1) );
                            var point1_ex = norm3.multiply(radius).add(po1);
                            t1_ex = core.addVertex(true, point1_ex);
                        }
                    }
                    if (edge.p2_mod != true) {
                        var point2a = c_core.vertex(edge.p2);
                        if (edge.f2 != null) var point2b = point2a;
                        t2_a = core.addVertex(true, point2a);
                        if (edge.f2 != null) t2_b = core.addVertex(true, point2b);
                        else t2_b = null;
                    } else if (edge.f2 != null) {
                        var c1_norm = c_core.normal(edge.f1);
                        var c2_norm = c_core.normal(edge.f2);
                        var c_cross = c1_norm.cross(c2_norm);
                        var c_dot = c1_norm.dot(c2_norm);
                        c_dot = (c_dot.norm)? c_dot.x : c_dot;
                        var c_cosT = c_dot / (Vec3D_len( c1_norm ) * Vec3D_len( c2_norm ));
                        //print('c_cross: '+c_cross.toString());
                        //print('c_angle: '+Math.acos(c_cosT)*radian_p);
                        if (false && c_cross.x < 0) { // 0-180 degree
                            //print('add_extra for p2');
                            norm1 = Vec3D_normalize( po2_ta.sub(po2) );
                            var point2a = norm1.multiply(radius).add(po2);
                            if (edge.f2 != null) {
                                norm2 = Vec3D_normalize( po2_tb.sub(po2) );
                                var point2b = norm2.multiply(radius).add(po2);
                            }
                            t2_a = core.addVertex(true, point2a);
                            if (edge.f2 != null) t2_b = core.addVertex(true, point2b);
                            // add extra point
                            norm3 = Vec3D_normalize( po1.sub(po2) );
                            var point2_ex = norm3.multiply(radius).add(po2);
                            t2_ex = core.addVertex(true, point2_ex);
                        }
                    }
                }
                
                // calc corner by weight
                corner1.addIndex(t1_a, t1_b, edge.f1, edge.f2);
                if (t1_ex != null) corner1.addIndex(t1_ex, t1_ex, edge.f1, edge.f2);
                if (edge.p1_ca == null) {
                    corner1.addIndex(t1_a, t1_b, -1, -1); // 
                    //print('add anonymous index p1');
                }
                if (corner1.normal != null) corner1.addNormal(edge.normal);
                else corner1.normal = edge.normal;
                corner1.p_weight = edge.p1_weigth;;

                corner2.addIndex(t2_a, t2_b, edge.f1, edge.f2);
                if (t2_ex != null) corner2.addIndex(t2_ex, t2_ex, edge.f1, edge.f2);
                if (edge.p2_ca == null) {
                    corner2.addIndex(t2_a, t2_b, -1, -1); // 
                    //print('add anonymous index p2');
                }
                if (corner2.normal != null) corner2.addNormal(edge.normal);
                else corner2.normal = edge.normal;
                corner2.p_weight = edge.p2_weight;
            }
            // adding face polygon
            for (var i = 0;i < pCount;i++) {
                var pSize = c_core.polygonSize(i);
                var normal = c_core.normal(i);
                var polygon = new Array;
                for (var j = 0;j < pSize;j++) {
                    var corner = corners[c_core.vertexIndex(i,j)];
                    var list = corner.getVertexIndex(i);
                    for (var k = 0;k < list.length;k++) {
                        polygon.pushUnique(list[k]);
                    }
                }
                var pSize_new = polygon.length;
                //print('p: ('+pSize+','+pSize_new+') '+polygon);
                if (pSize_new != pSize) polygon = getVertexOrder(core, normal, polygon)
                //print('p: ('+pSize+','+pSize_new+') '+polygon);
                if (pSize_new > 2) core.addIndexPolygon(polygon.length, polygon);
            }
            // adding corner polygon
            // this code is not completed yet for rounded corner 
            var c_len= corners.length;
            for (var i = 0;i < c_len;i++) {
                var corner = corners[i];
                var c_count = corner.e_list.length;
                var c_list = corner.getCornerList();
                var r_len = c_list.length;
                var c_normal = corner.normal;
                if (r_len == 3) {
                     if (detail == 1)  {
                        var polygon = getVertexOrder(core, c_normal, corner.getFaceList());
                        //print(corner.toString());
                        //print('p: '+polygon);
                        if (polygon.length > 2) {
                            var corner_pindex = core.addIndexPolygon(polygon.length, polygon);
                        }
                    } else if (detail % 2 == 0) {
                        var r_center = corner.r_center;
                        var r_radius = corner.r_radius;
                        var c_point = core.vertex(c_list[0]);
                        for (var ii = 1;ii < r_len;ii++) {
                            c_point = c_point.add(core.vertex(c_list[ii]));
                        }
                        c_point = c_point.multiply(1/r_len);
                        norm1 = Vec3D_normalize( c_point.sub(r_center) );
                        c_point = norm1.multiply(r_radius);
                        c_point = c_point.add(r_center);
                        
                        //var c_point = r_center.add(c_normal.multiply(radius));
                        
                        var c_p01 = core.vertex(c_list[0]).add(core.vertex(c_list[1])).multiply(1/2);
                        var c_p02 = core.vertex(c_list[0]).add(core.vertex(c_list[2])).multiply(1/2);
                        var c_p12 = core.vertex(c_list[1]).add(core.vertex(c_list[2])).multiply(1/2);
                        
                        norm1 = Vec3D_normalize( c_p01.sub(r_center) );
                        norm2 = Vec3D_normalize( c_p02.sub(r_center) );
                        norm3 = Vec3D_normalize( c_p12.sub(r_center) );
                        c_p01 = norm1.multiply(r_radius).add(r_center);
                        c_p02 = norm2.multiply(r_radius).add(r_center);
                        c_p12 = norm3.multiply(r_radius).add(r_center);
                        
                        var ct_c = core.addVertex(true, c_point);
                        var ct01 = core.addVertex(true, c_p01);
                        var ct02 = core.addVertex(true, c_p02);
                        var ct12 = core.addVertex(true, c_p12);
                        core.addIndexPolygon(4, getVertexOrder(core, c_normal, [c_list[0], ct01, ct_c, ct02]));
                        core.addIndexPolygon(4, getVertexOrder(core, c_normal, [c_list[1], ct12, ct_c, ct01]));
                        core.addIndexPolygon(4, getVertexOrder(core, c_normal, [c_list[2], ct02, ct_c, ct12]));
                    } else if (detail % 2 == 1) {
                        var r_center = corner.r_center;
                        var r_radius = corner.r_radius;
                        var c_point = core.vertex(c_list[0]);
                        for (var ii = 1;ii < r_len;ii++) {
                            c_point = c_point.add(core.vertex(c_list[ii]));
                        }
                        c_point = c_point.multiply(1/r_len);
                        c_point = Vec3D_normalize( c_point.sub(r_center) ).multiply(radius);
                        c_point = c_point.add(r_center);
                        
                        var c_p01 = core.vertex(c_list[0]).multiply(1/3).add(c_point.multiply(2/3));
                        var c_p02 = core.vertex(c_list[1]).multiply(1/3).add(c_point.multiply(2/3));
                        var c_p03 = core.vertex(c_list[2]).multiply(1/3).add(c_point.multiply(2/3));
                        norm1 = Vec3D_normalize( c_p01.sub(r_center) );
                        norm2 = Vec3D_normalize( c_p02.sub(r_center) );
                        norm3 = Vec3D_normalize( c_p03.sub(r_center) );
                        c_p01 = norm1.multiply(r_radius).add(r_center);
                        c_p02 = norm2.multiply(r_radius).add(r_center);
                        c_p03 = norm3.multiply(r_radius).add(r_center);
                        var ct01 = core.addVertex(true, c_p01);
                        var ct02 = core.addVertex(true, c_p02);
                        var ct03 = core.addVertex(true, c_p03);
                        core.addIndexPolygon(3, getVertexOrder(core, c_normal, [ct01, ct02, ct03])); // center triangle.
                        
                        var c_p01a = core.vertex(c_list[0]).multiply(2/3).add(core.vertex(c_list[1]).multiply(1/3));
                        var c_p01b = core.vertex(c_list[0]).multiply(2/3).add(core.vertex(c_list[2]).multiply(1/3));
                        norm1 = Vec3D_normalize( c_p01a.sub(r_center) );
                        norm2 = Vec3D_normalize( c_p01b.sub(r_center) );
                        c_p01a = norm1.multiply(r_radius).add(r_center);
                        c_p01b = norm2.multiply(r_radius).add(r_center);
                        var ct01a = core.addVertex(true, c_p01a);
                        var ct01b = core.addVertex(true, c_p01b);
                        core.addIndexPolygon(4, getVertexOrder(core, c_normal, [c_list[0], ct01a, ct01b, ct01]));
                        
                        var c_p02a = core.vertex(c_list[1]).multiply(2/3).add(core.vertex(c_list[0]).multiply(1/3));
                        var c_p02b = core.vertex(c_list[1]).multiply(2/3).add(core.vertex(c_list[2]).multiply(1/3));
                        norm1 = Vec3D_normalize( c_p02a.sub(r_center) );
                        norm2 = Vec3D_normalize( c_p02b.sub(r_center) );
                        c_p02a = norm1.multiply(r_radius).add(r_center);
                        c_p02b = norm2.multiply(r_radius).add(r_center);
                        var ct02a = core.addVertex(true, c_p02a);
                        var ct02b = core.addVertex(true, c_p02b);
                        core.addIndexPolygon(4, getVertexOrder(core, c_normal, [c_list[1], ct02a, ct02b, ct02]));
                        
                        var c_p03a = core.vertex(c_list[2]).multiply(2/3).add(core.vertex(c_list[0]).multiply(1/3));
                        var c_p03b = core.vertex(c_list[2]).multiply(2/3).add(core.vertex(c_list[1]).multiply(1/3));
                        norm1 = Vec3D_normalize( c_p03a.sub(r_center) );
                        norm2 = Vec3D_normalize( c_p03b.sub(r_center) );
                        c_p03a = norm1.multiply(r_radius).add(r_center);
                        c_p03b = norm2.multiply(r_radius).add(r_center);
                        var ct03a = core.addVertex(true, c_p03a);
                        var ct03b = core.addVertex(true, c_p03b);
                        core.addIndexPolygon(4, getVertexOrder(core, c_normal, [c_list[2], ct03a, ct03b, ct03]));
                        
                        core.addIndexPolygon(4, getVertexOrder(core, c_normal, [ct01, ct01a, ct02a, ct02]));
                        core.addIndexPolygon(4, getVertexOrder(core, c_normal, [ct02, ct02b, ct03b, ct03]));
                        core.addIndexPolygon(4, getVertexOrder(core, c_normal, [ct03, ct03a, ct01b, ct01]));
                    }
                } else {
                    var polygon = getVertexOrder(core, c_normal, corner.getFaceList());
                    //print(corner.toString());
                    //print('p: '+polygon);
                    if (polygon.length > 2) {
                        var corner_pindex = core.addIndexPolygon(polygon.length, polygon);
                    }
                }
            }
        }
    }
}