// Bend.js -- import from as3dmod modifier library, http://code.google.com/p/as3dmod/
//
// polygon script, place this file into ~/Library/Application Support/Cheetah3D/scripts/Polygonobj folder
//

var _minX;
var _minY;
var _minZ;

var _maxX;
var _maxY;
var _maxZ;

var _sizeX;
var _sizeY;
var _sizeZ;

var _maxAxis;
var _midAxis;
var _minAxis;

var ratios = new Array;

var Vec3D_setValue = function ( vec, axis, v ) {
	switch(axis) {
		case 0: vec.x = v; break;
		case 1: vec.y = v; break;
		case 2: vec.z = v; break;
	}
}

var Vec3D_getValue = function ( vec, axis ){
	switch(axis) {
		case 0: return vec.x;
		case 1: return vec.y;
		case 2: return vec.z;
	}
	return 0;
}

function buildUI(obj) {
	obj.setParameter("name", "Bend");
	
	obj.addParameterFloat("bend force", 0, -12, 12, true, true);
	obj.addParameterFloat("bend offset", 0.5, 0, 1.0, true, true);
	
	obj.addParameterSelector("bend axis", ["X", "Y", "Z"], true, true);
	obj.addParameterSelector("bend point", ["X", "Y", "Z"], true, true);
	
	obj.addParameterSelector("bend constraint", ["NONE", "LEFT", "RIGHT"], true, true);
	
    obj.addParameterSeparator("Smooth");
    obj.addParameterSelector("smooth",["normalFlat","normalPhong","normalContraint"],true,true);
    obj.addParameterFloat("smooth angle", 45.0, 5.0, 90.0, true, true);
	
	obj.setParameter("smooth", 2);
	
	obj.setCreatorObj(true);
}

function analyzeGeometry(g) {
	if (g.family() == NGONFAMILY) {
		var gcore = g.modCore();
		var mat = g.objMatrix(); //g.objMatrix();
		
		var gVertexCount = gcore.vertexCount();
		for (var i = 0;i < gVertexCount;i++) {
			var v = mat.multiply(gcore.vertex(i));
			
			if (i == 0) {
				_minX = _maxX = v.x;
				_minY = _maxY = v.y;
				_minZ = _maxZ = v.z;
			} else {
				_minX = Math.min(_minX, v.x);
				_minY = Math.min(_minY, v.y);
				_minZ = Math.min(_minZ, v.z);
				
				_maxX = Math.max(_maxX, v.x);
				_maxY = Math.max(_maxY, v.y);
				_maxZ = Math.max(_maxZ, v.z);
			}
		}
		_sizeX = _maxX - _minX;
		_sizeY = _maxY - _minY;
		_sizeZ = _maxZ - _minZ;
		
		for (var i = 0;i < gVertexCount;i++) {
			var v = mat.multiply(gcore.vertex(i));
			
			ratios[i] = new Vec3D((v.x - _minX)/_sizeX, (v.y - _minY)/_sizeY, (v.z - _minZ)/_sizeZ);
		}
	}
}

function mod_getMax(axis) {
	switch(axis) {
		case 0: return _maxX;
		case 1: return _maxY;
		case 2: return _maxZ;
	}
	return -1;
}

function mod_getMin(axis) {
	switch(axis) {
		case 0: return _minX;
		case 1: return _minY;
		case 2: return _minZ;
	}
	return -1;
}

function mod_getRatio(axis, i) {
	switch(axis) {
		case 0: return ratios[i].x;
		case 1: return ratios[i].y;
		case 2: return ratios[i].z;
	}
	return -1;
}

function buildObject(obj) {
	var core = obj.core();
	var force = obj.getParameter("bend force");
	if (force == 0) force = 0.0001;
	var maa = parseInt(obj.getParameter("bend axis"));
	var mia = parseInt(obj.getParameter("bend point"));
	var constraint = parseInt(obj.getParameter("bend constraint"));
	
	var offset = obj.getParameter("bend offset");
	
	obj.setParameter("normalType",obj.getParameter("smooth"),false);
	obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
	
	// resetting ratios array;
	ratios.length = 0;
	
	if (obj.childCount() > 0) {
		var g = obj.childAtIndex(0);
		if (g.family() == NGONFAMILY) {
			analyzeGeometry(g);
			
			var pto = mod_getMin(maa);
			var ptd = mod_getMax(maa) - pto;
			
			var distance = pto + ptd * offset;
			var radius = ptd / Math.PI / force;
			var force = Math.PI * 2 * (ptd / (radius * Math.PI * 2));
			
			var gcore = g.modCore();
			var mat = g.objMatrix(); //g.objMatrix();
			var gVertexCount = gcore.vertexCount();
			for (var i = 0;i < gVertexCount;i++) {
				var v = mat.multiply(gcore.vertex(i));
				
				var p = mod_getRatio(maa, i);
				
				if (constraint == 1 && p <= offset) { // LEFT
					core.addVertex(false, v);
				} else if (constraint == 2 && p >= offset) { // RIGHT
					core.addVertex(false, v);
				} else {
					var fa = ((Math.PI / 2) - force * offset) + (force * p);
					var op = Math.sin(fa) * (radius + Vec3D_getValue(v, mia)) - radius;
					var ow = distance - Math.cos(fa) * (radius + Vec3D_getValue(v, mia));
					
					Vec3D_setValue( v, mia, op);
					Vec3D_setValue(v, maa, ow);
					
					core.addVertex(false, v);
				}
			}
			var gPolygonCount = gcore.polygonCount();
			for (var i = 0; i < gPolygonCount;i++) {
				var gPolygonSize = gcore.polygonSize(i);
				var verts = new Array;
				for (var j = 0; j < gPolygonSize;j++) {
					verts.push(gcore.vertexIndex(i,j));
				}
				core.addIndexPolygon(gPolygonSize, verts); //, uvs);
				for (var j = 0; j < gPolygonSize;j++) {
					core.setUVCoord(i, j, gcore.uvCoord(i,j));
				}
			}
		}
	}
}