// Dissolve.js (Delete Edge.js)
//
// this is a Macro script for Cheetah3D. place this into ~/Library/Applciation Support/Cheetah3D/scripts/Macro folder

// v.20081216: first version
// v.20081216b: fixed multiple delete bug.
// v.20081217: optimize
// v.20081227: fix bug
// v.20090103: fix bug
// v.20090105: point mode added.
// v.20090109: delete point error fixed / uv setting error fixed.

// Array extension
Array.prototype.edge_detect = false;
Array.prototype.pushUniqueEdge = function(val) {
	var len = this.length;
	var res = true;
	for (var i = 0;i < len;i++) {
		if (this[i].equalTo(val)) {
			this[i].p2 = val.p1;
			this.edge_detect = true;
			res = false;
		}
	}
	if (res && val != null) {
		this[len] = val;
		return this.length;
	} else {
		return false;
	}
}
Array.prototype.pushUnique = function(val) {
	var len = this.length;
	var res = true;
	for (var i = 0;i < len;i++) {
		if (this[i] == val) {
			return false;
		}
	}
	this[len] = val;
	return this.length;
}
// Point Class
function Point(_vertex, _p_index) {
	this.vertex = _vertex;
	this.poly_count = 1;
	this.poly_list = [_p_index];
}
Point.prototype.toString = function() {
	return 'point:'+this.vertex+','+this.poly_count+':'+this.poly_list;
}
Point.prototype.setPoly = function (_p_index) {
	this.poly_list.push(_p_index);
	this.poly_count++;
}
// Edge Class
function Edge(v1, v2) {
	this.v1 = v1;
	this.v2 = v2;
	this.p1 = null;
	this.p2 = null;
}
Edge.prototype.toString = function () {
	return 'edge:'+this.v1+','+this.v2+' p:'+this.p1+','+this.p2;
}
Edge.prototype.equalTo = function (edge) {
	return (this.v1 == edge.v1 && this.v2 == edge.v2) || (this.v1 == edge.v2 && this.v2 == edge.v1);
}
// function 
function detectPointSelection(core) {
	var polyCount = core.polygonCount();
	var cache = new Array;
	for (var i = 0;i < polyCount;i++) {
		var polySize = core.polygonSize(i);
		
		for (var j = 0;j < polySize;j++) {
			var v1 = core.vertexIndex(i,j);
			if (core.vertexSelection(v1)) {
				var inserted = false;
				var len = cache.length;
				for (var k = 0;k < len;k++) {
					var p = cache[k];
					if (p.vertex == v1) {
						inserted = true;
						p.setPoly(i);
						cache[k] = p;
					}
				}
				if (! inserted) {
					var point = new Point(v1, i);
					cache.push(point);
				}
			}
		}
	}
	return cache;
}

function detectEdgeSelection(core) {
	var polyCount = core.polygonCount();
	var cache = new Array;
	for (var i = 0;i < polyCount;i++) {
		var polySize = core.polygonSize(i);
		
		for (var j = 0;j < polySize;j++) {
			if (core.edgeSelection(i, j, SELECT)) {
				var vn = (j == polySize - 1)? 0 : j+1;
				var v1 = core.vertexIndex(i, j);
				var v2 = core.vertexIndex(i, vn);
				var edge = new Edge(v1, v2);
				edge.p1 = i;
				cache.pushUniqueEdge(edge);
			}
		}
	}
	var len = cache.length;
	var list = new Array;
	for (i = 0;i < len;i++) {
		if (cache[i].p1 != null && cache[i].p2 != null) {
			list.push(cache[i]);
		}
	}
	return list;
}
//
function main(doc) {
	var obj = doc.selectedObject();
	
	if (! obj || obj.family() != NGONFAMILY) {
		return;
	}
	
	// bench
	var st1 = new Date().getTime();
	
	//print("---- Dissolve.js ----");
	var mode = doc.editMode();
	var poly_count = 0;
	
	if (mode == POINT_MODE) {
		poly_count = dissolvePoint(obj);
	} else if (mode ==  EDGE_MODE) {
		poly_count = dissolveEdge(obj);
	} else {
		var core = obj.core();
		var count = core.polygonCount();
		//print('pcount:'+count);
		for (var i = 0;i < count;i++) {
			if (core.polygonSelection(i)) {
				//print('sel:'+i);
			}
		}
		OS.beep();
	}
	
	obj.update();
	
	// bench
	var st2 = new Date().getTime();
	var st3 = st2 - st1;
	//print("bench:"+st3+", poly_count:"+poly_count);
}

function dissolvePoint(obj) {
	var core = obj.core();
	
	var poly_count = 0;
	var cache = detectPointSelection(core);
	
	while (cache.length > 0) {
		var point = cache[0];
		var cache_len = cache.length;
		var i,j,k;
		
		//print('dissolvePoint: '+cache.length+' ---');
		
		//
		point.poly_list = point.poly_list.sort().reverse();
		//point.poly_list = point.poly_list.sort();
		
		//print('---');
		//print(point);
		
		switch(point.poly_count) {
			case 1:
			case 2:
				var len = point.poly_count;
				for (i = 0;i < len;i++) {
					var poly = point.poly_list[i];
					var psize = core.polygonSize(poly);
					var vertices = [];
					var uvs = [];
					for (j = 0;j < psize;j++) {
						var vi = core.vertexIndex(poly,j);
						if (vi != point.vertex) {
							vertices.push(vi);
							uvs.push(core.uvCoord(poly,j));
						}
					}
					psize = vertices.length;
					if (psize > 3) {
						var pi = core.addIndexPolygon(psize, vertices);
						poly_count++;
						for (j = 0;j < psize - 1;j++) {
							if (uvs[j]) {
								core.setUVCoord(pi, j, uvs[j]);
							} else {
								print('error uvCoord undefined: '+j+'!!');
							}
						}
					}
				}
				var del_pol = 0;
				var del_poly_count = point.poly_count;
				var del_loop = 0;
				while (del_pol < del_poly_count) {
					//print('del:'+del_pol+'/'+del_poly_count);
					var pcount = core.polygonCount();
					for (i = 0;i < pcount;i++) {
						var psize = core.polygonSize(i);
						var del_p = undefined;
						for (j = 0;j < psize;j++) {
							if (point.vertex == core.vertexIndex(i,j)) {
								del_p = i;
							}
						}
						if (del_p != undefined) {
							core.deletePolygon(del_p);
							del_pol++;
							//print('del:'+del_p+', del_pol:'+del_pol+', '+point.poly_count);
							pcount = core.polygonCount();
						}
					}
					del_loop++;
					if (del_loop > pcount) {
						print('delete point error!!');
						break;
					}
				}
				//core.setVertexSelection(point.vertex, false);
				core.deleteVertex(point.vertex);
				
				break;
			default: // unified type
				var len = point.poly_count;
				var vertices = [];
				var uvs = [];
				for (i = 0;i < len;i++) {
					vertices[i] = [];
					uvs[i] = [];
					var poly = point.poly_list[i];
					var psize = core.polygonSize(poly);
					var vi_i = 0;
					var vi_start = false;
					while (vertices[i].length < psize - 1) {
						var vi = core.vertexIndex(poly, vi_i);
						if (vi_start) {
							vertices[i].push(vi);
							uvs[i].push(core.uvCoord(poly, vi_i));
						}
						if (vi == point.vertex) {
							vi_start = true;
						}
						vi_i = (vi_i == psize - 1)? 0 : vi_i + 1;
					}
				}
				//print(vertices);
				var cache_count = 1;
				var cache_loop = 0;
				var v_list = vertices[0];
				var uv_list = uvs[0];
				while (cache_count < len) {
					var last_i = v_list[v_list.length-1];
					for (i = 1;i < vertices.length;i++) {
						if (last_i == vertices[i][0]) {
							cache_count++;
							for (j = 1;j < vertices[i].length;j++) {
								v_list.push(vertices[i][j]);
								uv_list.push(uvs[i][j]);
							}
						}
					}
					cache_loop++;
					if (cache_loop > vertices.length - 1) {
						//print('loop stopped');
						cache_count = len; // stop loop
					}
				}
				//print(v_list);
				v_list.pop();
				//
				var del_pol = 0;
				var del_loop = 0;
				var del_poly_count = point.poly_count;
				while (del_pol < del_poly_count) {
					var pcount = core.polygonCount();
					for (i = 0;i < pcount;i++) {
						var psize = core.polygonSize(i);
						var del_p = undefined;
						for (j = 0;j < psize;j++) {
							if (point.vertex == core.vertexIndex(i,j)) {
								del_p = i;
							}
						}
						if (del_p != undefined) {
							core.deletePolygon(del_p);
							del_pol++;
							//print('del:'+del_p+', del_pol:'+del_pol+', '+point.poly_count);
							pcount = core.polygonCount();
						}
					}
					del_loop++;
					if (del_loop > pcount) {
						print('delete point error!!');
						break;
					}
				}
				//print('list:'+v_list);
				if (v_list.length > 2) {
					var pi = core.addIndexPolygon(v_list.length, v_list);
					//print('pi:'+pi);
					poly_count++;
					for (j = 0;j < v_list.length;j++) {
						core.setUVCoord(pi, j, uv_list[j]);
					}
					//core.setVertexSelection(point.vertex, false);
					core.deleteVertex(point.vertex);
				}
				break;
		}
		
		obj.update();
		
		cache = detectPointSelection(core);
	}
	
	return poly_count;
}

function dissolveEdge(obj) {
	var core = obj.core();
	
	var poly_count = 0;
	var cache = detectEdgeSelection(core);
	
	while (cache.length > 0) {
		// getting first edge of selection : 選択されたエッジの１番目を取得
		var edge = cache[0];
		var cache_len = cache.length;
		var i,j,k;
		
		if (edge.p1 != null && edge.p2 != null) {
			var list = new Array;
			var uvs = new Array;
			var uvs_info = new Array;
			var res = false;
			
			// getting vertices of polygons makes target edge : エッジ構成ポリゴンの頂点データを取得
			var s1_len = core.polygonSize(edge.p1);
			var s1_cache = [];
			for (j = 0;j < s1_len;j++) {
				var vi = core.vertexIndex(edge.p1, j);
				s1_cache.push(vi);
				uvs_info.push([vi, core.uvCoord(edge.p1, j)]);
			}
			var s2_len = core.polygonSize(edge.p2);
			var s2_cache = [];
			var s2_cache_s = [];
			var s2_j = 0;
			var s2_start = false;
			while (s2_cache.length < s2_len-2) {
				var vi = core.vertexIndex(edge.p2, s2_j);
				if (s2_start) {
					s2_cache.push(vi);
					uvs_info.push([vi, core.uvCoord(edge.p2, s2_j)]);
				}
				if (vi == edge.v1) {
					s2_start = true;
				} else if (vi == edge.v2) {
					s2_start = false;
				}
				s2_j = (s2_j == s2_len - 1)? 0 : s2_j+1;
			}
			for (j = 0;j < s2_len;j++) {
				var vi = core.vertexIndex(edge.p2, j);
				s2_cache_s.push(vi);
			}
			
			/*
			print('v1:'+edge.v1+', v2:'+edge.v2);
			print('s1:'+s1_cache);
			print('s2:'+s2_cache);
			print('s2s:'+s2_cache_s);
			*/
			
			for (j = 0;j < s1_len;j++) {
				vi = s1_cache[j];
				if (vi == edge.v1) {
					list.push(vi);
					for (k = 0;k < s2_len-2;k++) {
						list.push(s2_cache[k]);
					}
					j++;
					list.push(s1_cache[j]);
				} else {
					list.push(vi);
				}
			}
			
			
			// isolated point check : 孤立点のチェック
			var vert_count = core.vertexCount();
			var vert_list = [];
			for (i = 0;i < vert_count;i++) {
				vert_list[i] = [];
			}
			var poly_len = core.polygonCount();
			for (i = 0;i < poly_len;i++) {
				var polySize = core.polygonSize(i);
				for (var j = 0;j < polySize;j++) {
					var vert_index = core.vertexIndex(i,j);
					if (i != edge.p1 && i != edge.p2) vert_list[vert_index].push(i);
				}
			}
			var res_list = [];
			var list_len = list.length;
			for (i = 0;i < list.length;i++) {
				var vert_index = list[i];
				//print(vert_list[vert_index]);
				if (vert_list[vert_index] != undefined && vert_list[vert_index].length != 0) {
					res_list.push(vert_index);
				} else {
					;
				}
			}
			//
			
			var list_len = res_list.length;
			for (j = 0;j < list_len;j++) {
				var v_index = res_list[j];
				var uvs_length = uvs_info.length;
				for (var k = 0;k < uvs_length;k++) {
					var uv_info = uvs_info[k];
					if (uv_info[0] == v_index) {
						uvs.push(uv_info[1]);
					}
				}
			}
			
			if (res_list.length > 2) {
				var pi = core.addIndexPolygon(res_list.length, res_list);
				poly_count++;
			}
			
			// reselect edge for new polygon : 再選択
			for (j = 0;j < cache_len;j++) {
				var edge_sel = cache[j];
				for (k = 0;k < list_len;k++) {
					k_n = (k+1 == list_len)? 0 : k+1;
					if (edge_sel.v1 == res_list[k] && edge_sel.v2 == res_list[k_n]) {
						core.setEdgeSelection(pi, k, SELECT, true);
						//print('resel next');
					}
					if (edge_sel.v2 == res_list[k] && edge_sel.v1 == res_list[k_n]) {
						core.setEdgeSelection(pi, k, SELECT, true);
						//print('resel back');
					}
				}
			}
			// setting UVCoord : UV セット
			for (j = 0;j < list_len;j++) {
				core.setUVCoord(pi, j, uvs[j]);
			}
			
			// delete polygon : ポリゴンを削除
			core.deletePolygon(edge.p1);
			core.deletePolygon(edge.p2);
			
			// update : 頂点番号の更新？用にオブジェクトをアップデート
			obj.update();
		}
		
		// update selection cache : 選択キャッシュを更新
		cache = detectEdgeSelection(core);
	}
	
	return poly_count;
}