//
//  MandelbulbApp.h
//  Mandelbulb
//
//  Created by Hiroto Tsubaki on 10/03/10.
//  Copyright 2010 Hiroto Tsubaki. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Accelerate/Accelerate.h>
#import "DDCommandLineInterface.h"


@interface MandelbulbApp : NSObject <DDCliApplicationDelegate>
{
	NSString * _output;
	NSString * _s_output;
	
	float  _power;
	float  _bailout;
	
	float  _phase_x;
	float  _phase_y;
	
	int    _resolutions;
	int    _iterations;
		
	BOOL   _julia;
	float  _julia_x;
	float  _julia_y;
	float  _julia_z;
	
	BOOL   _radiolaria;
	double _radiolariaFactor;
	
	float _scale;
	
	double _minx;
	double _miny;
	double _minz;
	
	double _maxx;
	double _maxy;
	double _maxz;
	
	float  _inner;
	float  _outer;
	
    BOOL   _version;
    BOOL   _help;
	
	float  _iso;
	int    _smooth;
	
	BOOL   _useGCD;
	
}

@end
