//
// Blow.js (Explosion.js)
//
//  v.110416
//  required version : Cheetah3D v3.6
//
//  (c) 2006-2011 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 2006-01-31 created.
// 2006-02-02 modified something.
// 2006-02-04 bug fix.
// 2007-09-28 change codes for speed and random movements.
// 2008-08-01 fix a problem with v.4.6.1
// 2008-08-13 keep polygon selection of base object.
// 2011-04-23 rename Blow.js / refactored.
//
// Usage: Place this into scripts/Polygonobj folder. restart Cheetah3D, then select from Tools -> Scritp -> Polygon Script
//

var randoms = [];
var random_seed = null;

var radian_p = 180/Math.PI;

if (!Array.pushUnique) {
  Array.prototype.pushUnique = function(value) {
    var result = false;
    for (var i = 0;i < this.length;i++) {
      if (this[i] == value) {
        result = i;
      }
    }

    if (result == false) return this.push( value );
    else return result;
  }
}

function buildUI(obj){
    
    obj.setParameter("name","Blow");
        
    obj.addParameterLink("blow core", true);
    
    obj.addParameterSelector("blow area", ["core radius", "blow core radius", "infinite"], true, true);
    obj.addParameterFloat("core radius", 0.1, 0, 10000, true, true);
    obj.addParameterFloat("core power", 0.1, -10000, 10000, true, true);
    obj.addParameterFloat("core power var.", 0, -10000, 10000, true, true);
    obj.addParameterSelector("blow curve", [ "1/distance", "1/distance^2", "distance" ], true, true );
    obj.addParameterFloat("delay", 0, -10000, 10000, true, true);
    obj.addParameterBool("grouped", 0, 0, 1, true, true);

    obj.addParameterSeparator("randoms");
    
    obj.addParameterInt("random seed", 123456, 0, 999999, true, true);

    obj.addParameterFloat("pos var. x", 0, -36000, 36000, true, true);
    obj.addParameterFloat("pos var. y", 0, -36000, 36000, true, true);
    obj.addParameterFloat("pos var. z", 0, -36000, 36000, true, true);

    obj.addParameterFloat("rot blow", 0, -1000, 1000, true, true);
    obj.addParameterFloat("rot blow var.", 0, -1000, 1000, true, true);
    
    obj.addParameterFloat("rot x", 0, -36000, 36000, true, true);
    obj.addParameterFloat("rot y", 0, -36000, 36000, true, true);
    obj.addParameterFloat("rot z", 0, -36000, 36000, true, true);
    obj.addParameterFloat("rot var. x", 0, -36000, 36000, true, true);
    obj.addParameterFloat("rot var. y", 0, -36000, 36000, true, true);
    obj.addParameterFloat("rot var. z", 0, -36000, 36000, true, true);
    
    obj.addParameterFloat("add scale x", 0, -36000, 36000, true, true);
    obj.addParameterFloat("add scale y", 0, -36000, 36000, true, true);
    obj.addParameterFloat("add scale z", 0, -36000, 36000, true, true);
    obj.addParameterFloat("add scale var. x", 0, -36000, 36000, true, true);
    obj.addParameterFloat("add scale var. y", 0, -36000, 36000, true, true);
    obj.addParameterFloat("add scale var. z", 0, -36000, 36000, true, true);
    
    obj.addParameterSeparator("Smooth"); // normal type
    obj.addParameterSelector("smooth",["flat","phong","constraint"],true,true);
    obj.addParameterFloat("smooth angle",45,1,180,true,true);
    

    obj.setParameter("smooth",2);
    obj.setCreatorObj( true );
}


function saveToFile(obj) {
    var filepath = OS.runSavePanel("randdata");
    var file = new File( filepath );

    file.open(WRITE_MODE, LITTLE_ENDIAN);
    var len = randoms.length;
    for (var i = 0;i < len;i++) {
        file.writeFloat( randoms[i].x );
        file.writeFloat( randoms[i].y );
        file.writeFloat( randoms[i].z );
    }
    file.close();
}

function loadFromFile(obj) {
    var filepath = OS.runOpenPanel("randdata");
    var file = new File( filepath );
    var index = 0;

    randoms.length = 0;

    file.open(READ_MODE, LITTLE_ENDIAN);
    while( file.getpos() + 12 <= file.size() ) {
        randoms[index] = new Vec3D( file.readFloat(), file.readFloat(), file.readFloat() );;
        index++;
    }
    file.close();

    obj.update();
}

function setRandoms(count) {

    var len = randoms.length;

    Math.seedrandom( random_seed );    

    for (var i = len-1;i < count;i++) {
        randoms[i] = new Vec3D( Math.random(), Math.random(), Math.random() );
    }
}

function buildObject(obj){
    var core = obj.core();
    
    var blowCore = obj.getParameter("blow core");
    //print('----');
    if (!blowCore) return;
    obj.setParameter("normalType",obj.getParameter("smooth"),false);
    obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
    
    var coreMat = blowCore.obj2WorldMatrix();
    
    var i, j;
    var area = obj.getParameter("blow area");
    var radius;
    if (area == 1 && blowCore.type() == BALL) {
        radius = blowCore.getParameter("radius");
    } else {
        radius = obj.getParameter("core radius");
    }
    var delay = obj.getParameter("delay");
    var power = obj.getParameter("core power");
    var power_var = obj.getParameter("core power var.");
    var corePos = coreMat.multiply( new Vec3D() );
    var curve = obj.getParameter("blow curve");
    var grouped = obj.getParameter("grouped");

    switch(curve) {
        case 0:
            var curveFunc = function() { return arguments[0] / ( arguments[1] ) };
            break;
        case 1:
            var curveFunc = function() { return arguments[0] / ( Math.pow( arguments[1], 2 ) ) };
            break;
        case 2:
            var curveFunc = function() { return arguments[0] * arguments[1] };
            break;
    }
    
    var rot_blow = obj.getParameter("rot blow");
    var rot_blow_var = obj.getParameter("rot blow var.");

    var rot_x = obj.getParameter("rot x");
    var rot_y = obj.getParameter("rot y");
    var rot_z = obj.getParameter("rot z");
    var rot_var_x = obj.getParameter("rot var. x");
    var rot_var_y = obj.getParameter("rot var. y");
    var rot_var_z = obj.getParameter("rot var. z");
    var scale_x = obj.getParameter("add scale x");
    var scale_y = obj.getParameter("add scale y");
    var scale_z = obj.getParameter("add scale z");
    var scale_var_x = obj.getParameter("add scale var. x");
    var scale_var_y = obj.getParameter("add scale var. y");
    var scale_var_z = obj.getParameter("add scale var. z");

    var posx = obj.getParameter("pos var. x");
    var posy = obj.getParameter("pos var. y");
    var posz = obj.getParameter("pos var. z");
    

    if (random_seed == null) {
        random_seed = obj.getParameter("random seed");
    } else if (random_seed != obj.getParameter("random seed")) {
        random_seed = obj.getParameter("random seed");
        randoms.length = 0;
    }

    //print("------ Explosion ------");
    
    //print(expCenter.x + ':' + expCenter.y + ':' + expCenter.z);
    //print('norm:'+expCenter.norm());
    //print('a*vt:'+areaRound * expVt);
    if (obj.childCount() > 0) {
        var base;
        base = obj.childAtIndex(0);
        
        if (base.family() == NGONFAMILY) {
            var baseCore = base.modCore();
            var basePolyCount = baseCore.polygonCount();
            var baseMat = base.obj2WorldMatrix();
            var baseMat_inverse = obj.objMatrix().inverse();

            if (randoms.length < basePolyCount) {
                setRandoms(basePolyCount);
            }
            
            // store polygon group
            var groups = [];
            var checked = [];
            for (i = 0;i < basePolyCount;i++) {
                if (checked.indexOf( i ) == -1) {
                    var polyIndices = [ i ];
                    var vertIndices = [];
                    var polygonSize = baseCore.polygonSize(i);
                    for (j = 0;j < polygonSize;j++) {
                        vertIndices.push( baseCore.vertexIndex( i, j ) );
                    }
                    checked.push( i );

                    //search neighbors
                    if (grouped) {
                        for (j = 0;j < basePolyCount;j++) {
                            if (checked.indexOf( j ) == -1) {
                                polygonSize = baseCore.polygonSize(j);
                                for (k = 0;k < polygonSize;k++) {
                                    var vertIndex = baseCore.vertexIndex( j, k );
                                    if (vertIndices.indexOf( vertIndex ) != -1) {
                                        // is neighbor
                                        polyIndices.push( j );
                                        checked.push( j );
                                        for (l = 0;l < polygonSize;l++) {
                                            vertIndices.pushUnique( baseCore.vertexIndex(j, l) );
                                        }
                                        // exit loop;
                                        k = polygonSize;
                                    }
                                }
                            }
                        }
                    }

                    //
                    //print( 'polyIndices: ' + polyIndices );
                    //print( 'vertIndices: ' + vertIndices );
                    groups.push( { pindices: polyIndices, vindices: vertIndices });
                }
            }

            var glen = groups.length;
            //print( 'groups: ' + glen );
            for (i = 0;i < glen;i++) {

                var group = groups[i];

                var pindices = group.pindices;
                var vindices = group.vindices;
                var pos = new Vec3D(0,0,0);
                var normal = new Vec3D(0,0,0);

                for (j = 0;j < pindices.length;j++) {
                    if (j == 0) {
//                        normal = baseMat.multiply(baseCore.normal(pindices[0]));
                        normal = baseCore.normal(pindices[j]);
                    } else {
//                        normal = normal.add( baseMat.multiply(baseCore.normal(pindices[j])));
                        normal = normal.add( baseCore.normal(pindices[j]) );
                    }
                }
                normal = normal.multiply(1/pindices.length);
                //print( 'normal: ' + normal.x.toFixed(2) + ', ' + normal.y.toFixed(2) + ', ' + normal.z.toFixed(2) );

                for (j = 0;j < vindices.length;j++) { // store vertex and uv info to Verts, UVs 
                    if (j == 0) {
                        pos = baseMat.multiply(baseCore.vertex(vindices[0]));
                    } else {
                        var vertex = baseMat.multiply(baseCore.vertex(vindices[j]));
                    
                        pos = pos.add( vertex );
                    }
                    //print( pos.x.toFixed(3) + ', ' + pos.y.toFixed(3) + ', ' + pos.z.toFixed(3) );
                }
                //calculate each polygon center
                pos = pos.multiply(1/vindices.length);
                
                //print( vindices.length );
                //print( 'center:' + pos.x.toFixed(3) + ', ' + pos.y.toFixed(3) + ', ' + pos.z.toFixed(3) );

                // calculate blow direction
                var dir = pos.sub(corePos);
                var distance = Math.sqrt( dir.x*dir.x + dir.y*dir.y + dir.z*dir.z );

                var vec = dir.multiply( 1 / dir.norm() );
                var rnd = randoms[i];
                
                distance += delay * rnd.y;
                var d = 0;
                var move_vec;
                if (area == 2 || distance < radius) {
                    d = curveFunc( power + ( rnd.x * power_var ), distance );
                    move_vec = vec.multiply( d );
                } else {
                    move_vec = new Vec3D();
                }

                // blow rotation
                if (rot_blow != 0) {

                    
                    var theta = Math.acos(normal.y)*radian_p;
                    var phi = Math.atan2(normal.x, normal.z)*radian_p;

                    //print( i + ':' + theta.toFixed(2) + ', ' + phi.toFixed(2) );

                    var rot_A = new Mat4D(ROTATE_HPB,
                                        phi,
                                        theta,
                                        0 );

                    var vec_dot = normal.dot( vec);
                    vec_dot = (vec_dot.norm)? vec_dot.x : vec_dot;

                    var rot_B = new Mat4D(ROTATE_HPB,
                                        vec_dot * radian_p,
                                        0,
                                        0 );

                    var rot_C = new Mat4D( ROTATE_HPB,
                                        0,
                                        -90  * (rot_blow + rot_blow_var * rnd.z) * d,
                                        0 );

                    //print( rot_blow_vec.x.toFixed(2) + ', ' + rot_blow_vec.y.toFixed(2) + ', ' + rot_blow_vec.z.toFixed(2) );

                    var rot_dists = [];

                    for (var ij = 0;ij < vindices.length;ij++) {
                        var vpos = baseMat.multiply( baseCore.vertex(vindices[ij]) );
                        var rbp = vpos.sub( corePos );
                        rot_dists.push( [ Math.sqrt( rbp.x*rbp.x + rbp.y*rbp.y + rbp.z*rbp.z ), vpos, ij ] );
                    }
                    //print( rot_dists );

                    rot_dists.sort( compDist );

                    var rb_pos = pos.sub( rot_dists[0][1] );
                    var rot_blow_trans_matrix = new Mat4D(TRANSLATE, 
                                        rb_pos.x,
                                        rb_pos.y,
                                        rb_pos.z
                                        );

                    rot_blow_matrix = rot_A.inverse().multiply( rot_B.inverse().multiply( rot_C.multiply( rot_B.multiply( rot_A ) ) ));
                    rot_blow_matrix = rot_blow_trans_matrix.inverse().multiply( rot_blow_matrix.multiply( rot_blow_trans_matrix ));

                } else {
                    var rot_blow_matrix = new Mat4D(TRANSLATE, 0, 0, 0);
                }

                //
                var p_pos = move_vec.add( new Vec3D((posx/2-rnd.x*posx)*d, (posy/2-rnd.y*posy)*d, (posz/2-rnd.z*posz)*d) );
                //
                var sx = 1 + (scale_x+(rnd.x*scale_var_x)) * d;
                var sy = 1 + (scale_y+(rnd.x*scale_var_y)) * d;
                var sz = 1 + (scale_z+(rnd.x*scale_var_z)) * d;
                if (sx < 0) continue;
                if (sy < 0) continue;
                if (sz < 0) continue;
                var scale_matrix = new Mat4D(SCALE,
                                    sx,
                                    sy,
                                    sz
                                    );
                var rot_matrix = new Mat4D(ROTATE, 
                                    (rot_x+(rot_var_x/2-rnd.x*rot_var_x)) * d,
                                    (rot_y+(rot_var_y/2-rnd.y*rot_var_y)) * d,
                                    (rot_z+(rot_var_z/2-rnd.z*rot_var_z)) * d
                                    );

                var indices_cache = [];
                for (j = 0;j < pindices.length;j++) {
                    var indices = [];
                    var uvs = [];
                    var polygonSize = baseCore.polygonSize(pindices[j]);
                    for (k = 0;k < polygonSize;k++) {
                        var vertex = baseMat.multiply( baseCore.vertex( baseCore.vertexIndex( pindices[j], k ) ) );
                        var create = -1;

                        for (l = 0;l < indices_cache.length;l++) {
                            if (indices_cache[l][0].isEqual( vertex ) ) {
                                create = indices_cache[l][1];
                            }
                        }

                        if (create > -1) {
                            indices[k] = create;
                        } else {
                            indices[k] = core.addVertex(false, baseMat_inverse.multiply( 
                                    p_pos.add( pos.add( rot_matrix.multiply( rot_blow_matrix.multiply( scale_matrix.multiply( vertex.sub( pos )))))) ) );
                            indices_cache.push( [ vertex, indices[k] ]);

                        }

                        uvs[k] = baseCore.uvCoord( pindices[j], k );
                    }

                    var p_index = core.addIndexPolygon(polygonSize, indices);
                    for (k = 0;k < polygonSize;k++) {
                        core.setUVCoord(p_index, k, uvs[k]);
                    }
                    // polygon selection
                    for (k = 0;k < 16;k++) {
                        baseCore.setActivePolygonSelection(k);
                        core.setActivePolygonSelection(k);
                        core.setPolygonSelection(p_index, baseCore.polygonSelection(pindices[j]));
                    }
                }
            }
            core.setActivePolygonSelection(0);
            baseCore.setActivePolygonSelection(0);
        }
    }
}

function compDist(a, b) {
    return (b[0] - a[0]);
}

// seeded random

/**
 * All code is in an anonymous closure to keep the global namespace clean.
 */
(function (
    global, pool, math, width, chunks, digits, module, define, rngname) {

//
// The following constants are related to IEEE 754 limits.
//
var startdenom = math.pow(width, chunks),
    significance = math.pow(2, digits),
    overflow = significance * 2,
    mask = width - 1,

//
// seedrandom()
// This is the seedrandom function described above.
//
impl = math['seed' + rngname] = function(seed, options, callback) {
  var key = [];
  options = (options == true) ? { entropy: true } : (options || {});

  // Flatten the seed string or build one from local entropy if needed.
  var shortseed = mixkey(flatten(
    options.entropy ? [seed, tostring(pool)] :
    (seed == null) ? autoseed() : seed, 3), key);

  // Use the seed to initialize an ARC4 generator.
  var arc4 = new ARC4(key);

  // Mix the randomness into accumulated entropy.
  mixkey(tostring(arc4.S), pool);

  // Calling convention: what to return as a function of prng, seed, is_math.
  return (options.pass || callback ||
      // If called as a method of Math (Math.seedrandom()), mutate Math.random
      // because that is how seedrandom.js has worked since v1.0.  Otherwise,
      // it is a newer calling convention, so return the prng directly.
      function(prng, seed, is_math_call) {
        if (is_math_call) { math[rngname] = prng; return seed; }
        else return prng;
      })(

  // This function returns a random double in [0, 1) that contains
  // randomness in every bit of the mantissa of the IEEE 754 value.
  function() {
    var n = arc4.g(chunks),             // Start with a numerator n < 2 ^ 48
        d = startdenom,                 //   and denominator d = 2 ^ 48.
        x = 0;                          //   and no 'extra last byte'.
    while (n < significance) {          // Fill up all significant digits by
      n = (n + x) * width;              //   shifting numerator and
      d *= width;                       //   denominator and generating a
      x = arc4.g(1);                    //   new least-significant-byte.
    }
    while (n >= overflow) {             // To avoid rounding up, before adding
      n /= 2;                           //   last byte, shift everything
      d /= 2;                           //   right using integer math until
      x >>>= 1;                         //   we have exactly the desired bits.
    }
    return (n + x) / d;                 // Form the number within [0, 1).
  }, shortseed, 'global' in options ? options.global : (this == math));
};

//
// ARC4
//
// An ARC4 implementation.  The constructor takes a key in the form of
// an array of at most (width) integers that should be 0 <= x < (width).
//
// The g(count) method returns a pseudorandom integer that concatenates
// the next (count) outputs from ARC4.  Its return value is a number x
// that is in the range 0 <= x < (width ^ count).
//
/** @constructor */
function ARC4(key) {
  var t, keylen = key.length,
      me = this, i = 0, j = me.i = me.j = 0, s = me.S = [];

  // The empty key [] is treated as [0].
  if (!keylen) { key = [keylen++]; }

  // Set up S using the standard key scheduling algorithm.
  while (i < width) {
    s[i] = i++;
  }
  for (i = 0; i < width; i++) {
    s[i] = s[j = mask & (j + key[i % keylen] + (t = s[i]))];
    s[j] = t;
  }

  // The "g" method returns the next (count) outputs as one number.
  (me.g = function(count) {
    // Using instance members instead of closure state nearly doubles speed.
    var t, r = 0,
        i = me.i, j = me.j, s = me.S;
    while (count--) {
      t = s[i = mask & (i + 1)];
      r = r * width + s[mask & ((s[i] = s[j = mask & (j + t)]) + (s[j] = t))];
    }
    me.i = i; me.j = j;
    return r;
    // For robust unpredictability discard an initial batch of values.
    // See http://www.rsa.com/rsalabs/node.asp?id=2009
  })(width);
}

//
// flatten()
// Converts an object tree to nested arrays of strings.
//
function flatten(obj, depth) {
  var result = [], typ = (typeof obj), prop;
  if (depth && typ == 'object') {
    for (prop in obj) {
      try { result.push(flatten(obj[prop], depth - 1)); } catch (e) {}
    }
  }
  return (result.length ? result : typ == 'string' ? obj : obj + '\0');
}

//
// mixkey()
// Mixes a string seed into a key that is an array of integers, and
// returns a shortened string seed that is equivalent to the result key.
//
function mixkey(seed, key) {
  var stringseed = seed + '', smear, j = 0;
  while (j < stringseed.length) {
    key[mask & j] =
      mask & ((smear ^= key[mask & j] * 19) + stringseed.charCodeAt(j++));
  }
  return tostring(key);
}

//
// autoseed()
// Returns an object for autoseeding, using window.crypto if available.
//
/** @param {Uint8Array|Navigator=} seed */
function autoseed(seed) {
  try {
    global.crypto.getRandomValues(seed = new Uint8Array(width));
    return tostring(seed);
  } catch (e) {
    return [+new Date, global, (seed = global.navigator) && seed.plugins,
            global.screen, tostring(pool)];
  }
}

//
// tostring()
// Converts an array of charcodes to a string
//
function tostring(a) {
  return String.fromCharCode.apply(0, a);
}

//
// When seedrandom.js is loaded, we immediately mix a few bits
// from the built-in RNG into the entropy pool.  Because we do
// not want to intefere with determinstic PRNG state later,
// seedrandom will not call math.random on its own again after
// initialization.
//
mixkey(math[rngname](), pool);

//
// Nodejs and AMD support: export the implemenation as a module using
// either convention.
//
if (module && module.exports) {
  module.exports = impl;
} else if (define && define.amd) {
  define(function() { return impl; });
}

// End anonymous scope, and pass initial values.
})(
  this,   // global window object
  [],     // pool: entropy pool starts empty
  Math,   // math: package containing random, pow, and seedrandom
  256,    // width: each RC4 output is 0 <= x < 256
  6,      // chunks: at least six RC4 outputs for each double
  52,     // digits: there are 52 significant digits in a double
  (typeof module) == 'object' && module,    // present in node.js
  (typeof define) == 'function' && define,  // present with an AMD loader
  'random'// rngname: name for Math.random and Math.seedrandom
);

