// Alignment+.js
//
//

function buildUI( tool ) {
  tool.addParameterSeparator("Alignment+");
  
  tool.addParameterLink("base obj", false);
  
  tool.addParameterSelector("x axis", [ "none", "|←", "→|←", "→|", "|↔|" ], false, false);
  tool.addParameterSelector("y axis", [ "none", "|←", "→|←", "→|", "|↔|" ], false, false);
  tool.addParameterSelector("z axis", [ "none", "|←", "→|←", "→|", "|↔|" ], false, false);
  
  tool.addParameterFloat("margin", 0, -10000, 10000, false, false);
  
  tool.addParameterButton("align", "apply", "doAlign");
}

function doAlign( tool ) {
  var doc = tool.document();
  var obj = doc.selectedObject();
  var base = tool.getParameter("base obj");
  
  if (!obj) return;
  
  if (base) {
    var baseBoundingBox = getBoundingBox( base );
  } else {
    var baseBoundingBox = [ new Vec3D(), new Vec3D() ];
  }
  
//  print('----');
  
  var move = new Vec3D();
  
  var objBoundingBox = getBoundingBox( obj );
  
  var alignX = tool.getParameter("x axis");
  var alignY = tool.getParameter("y axis");
  var alignZ = tool.getParameter("z axis");
  var margin = tool.getParameter("margin");
  
  var baseMax = baseBoundingBox[0];
  var baseMin = baseBoundingBox[1];
  var baseCenter = baseMax.add( baseMin ).multiply( 1/2 );
  
  var objMax = objBoundingBox[0];
  var objMin = objBoundingBox[1];
  var objCenter = objMax.add( objMin ).multiply( 1/2 );
  
//  Vec3D_print( 'base max:', baseMax );
//  Vec3D_print( 'base min:', baseMin );
//  Vec3D_print( 'base center:', baseCenter);
//
//  Vec3D_print( 'obj max:', objMax );
//  Vec3D_print( 'obj min:', objMin );
//  Vec3D_print( 'obj center:', objCenter);
  
  switch( parseInt( alignX ) ) {
    case 0:
      break;
    case 1:
      move.x = getMoveValue( baseMin, objMin, 'x');
      break;
    case 2:
      move.x = getMoveValue( baseCenter, objCenter, 'x');
      break;
    case 3:
      move.x = getMoveValue( baseMax, objMax, 'x');
      break;
    case 4:
      move.x = getMoveValue( baseMax, objMin, 'x') + margin;
  }
  
  switch( parseInt( alignY ) ) {
    case 0:
      break;
    case 1:
      move.y = getMoveValue( baseMin, objMin, 'y');
      break;
    case 2:
      move.y = getMoveValue( baseCenter, objCenter, 'y');
      break;
    case 3:
      move.y = getMoveValue( baseMax, objMax, 'y');
      break;
    case 4:
      move.y = getMoveValue( baseMax, objMin, 'y') + margin;
      break;
  }
  
  switch( parseInt( alignZ ) ) {
    case 0:
      break;
    case 1:
      move.z = getMoveValue( baseMin, objMin, 'z');
      break;
    case 2:
      move.z = getMoveValue( baseCenter, objCenter, 'z');
      break;
    case 3:
      move.z = getMoveValue( baseMax, objMax, 'z');
      break;
    case 4:
      move.z = getMoveValue( baseMax, objMin, 'z') + margin;
      break;
    
  }
  
//  Vec3D_print( 'move:', move );
  
  move = obj.getParameter("position").add( move );
  
//  Vec3D_print( 'set:', move );
  
  if (tool.parameterWithName) obj.recordParametersForUndo();
  
  obj.setParameter("position", move, true);
}

function getMoveValue( v0, v1, element, type ) {
  var e0, e1;
  switch( element ) {
    case 'x':
      e0 = v0.x;
      e1 = v1.x;
      break;
    case 'y':
      e0 = v0.y;
      e1 = v1.y;
      break;
    case 'z':
      e0 = v0.z;
      e1 = v1.z;
      break;
  }
  return (e0 - e1);
}

function getBoundingBox( obj ) {
  var max = null;
  var min = null;
  
  var childCount = obj.childCount();
  for (var i = 0;i < childCount;i++) {
    var child = obj.childAtIndex( i );
    var boundingBox = getBoundingBox( child );
    
    if (max == null && min == null) {
      max = boundingBox[0];
      min = boundingBox[1];
    } else {
      max.x = Math.max( boundingBox[0].x, max.x );
      max.y = Math.max( boundingBox[0].y, max.y );
      max.z = Math.max( boundingBox[0].z, max.z );
      
      min.x = Math.min( boundingBox[1].x, min.x );
      min.y = Math.min( boundingBox[1].y, min.y );
      min.z = Math.min( boundingBox[1].z, min.z );
    }
  }
  var mat = obj.obj2WorldMatrix();
  
  if (obj.family() == NGONFAMILY) {
    var core = obj.modCore();
    var vertexCount = core.vertexCount();
    
    for (var i = 0;i < vertexCount;i++) {
      var vertex = mat.multiply( core.vertex( i ) );
      
      if (max == null && min == null) {
        max = vertex.copy();
        min = vertex.copy();
      } else {
        max.x = Math.max( vertex.x, max.x );
        max.y = Math.max( vertex.y, max.y );
        max.z = Math.max( vertex.z, max.z );
        
        min.x = Math.min( vertex.x, min.x );
        min.y = Math.min( vertex.y, min.y );
        min.z = Math.min( vertex.z, min.z );
      }
    }  
  } else if (obj.family() == SPLINEFAMILY) {
    var core = obj.modCore();
    var pathCount = core.pathCount();
    for (var i = 0;i < pathCount;i++) {
      var points = core.cache( i );
      var len = points.length;
      for (var j = 0;j < len;j++) {
        var point = mat.multiply( points[j] );
        
        if (max == null && min == null) {
          max = point.copy();
          min = point.copy();
        } else {
          max.x = Math.max( point.x, max.x );
          max.y = Math.max( point.y, max.y );
          max.z = Math.max( point.z, max.z );
          
          min.x = Math.min( point.x, min.x );
          min.y = Math.min( point.y, min.y );
          min.z = Math.min( point.z, min.z );
        }
      }
    }
  } else {
    max = new Vec3D();
    min = new Vec3D();
  }
  
  return [ max, min ];
}

function Vec3D_print( str, vec ) {
  print( str + vec.x.toFixed(3) + ', ' + vec.y.toFixed(3) + ', ' + vec.z.toFixed(3) );
}